/*
 * Decompiled with CFR 0.152.
 */
package jeus.persistence.container;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import jeus.management.j2ee.DeploymentException;
import jeus.persistence.container.PersistenceProviders;
import jeus.persistence.container.PersistenceUnits;
import jeus.persistence.container.TransformableClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JPA;
import jeus.xml.binding.j2ee.Persistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.persistence");
    protected String unitName;
    protected String persistenceProviderClassName;
    protected PersistenceUnitTransactionType transactionType;
    protected DataSource jtaDataSource;
    protected DataSource nonJtaDataSource;
    protected List<String> mappingFileNames;
    protected List<URL> jarFilesUrls;
    protected URL persistenceUnitRootUrl;
    protected List<String> managedClassNames;
    protected boolean excludeUnlistedClasses;
    protected Properties properties;
    protected ClassLoader classLoader;

    public PersistenceUnitInfoImpl(Persistence.PersistenceUnit punit, PersistenceUnits units, ClassLoader loader) throws DeploymentException {
        block33: {
            this.unitName = punit.getName();
            if (PersistenceUnitInfoImpl.isNullOrEmpty(this.unitName)) {
                this.unitName = "";
            }
            this.persistenceProviderClassName = punit.getProvider();
            if (PersistenceUnitInfoImpl.isNullOrEmpty(this.persistenceProviderClassName)) {
                this.persistenceProviderClassName = PersistenceProviders.getDefaultPersistenceProviderClassName();
            }
            this.transactionType = PersistenceUnitTransactionType.JTA;
            if (punit.isSetTransactionType() && punit.getTransactionType() == jeus.xml.binding.j2ee.PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                this.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }
            String jtaDataSourceName = punit.getJtaDataSource();
            String nonJtaDataSourceName = punit.getNonJtaDataSource();
            String DEFAULT_DS = "jdbc/__default";
            if (PersistenceUnitInfoImpl.isNullOrEmpty(jtaDataSourceName) && PersistenceUnitInfoImpl.isNullOrEmpty(nonJtaDataSourceName)) {
                jtaDataSourceName = "jdbc/__default";
                nonJtaDataSourceName = "jdbc/__default";
            }
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                switch (this.transactionType) {
                    case JTA: {
                        if (PersistenceUnitInfoImpl.isNullOrEmpty(jtaDataSourceName)) {
                            throw new DeploymentException("jta-data-source should be given for the persistence unit " + this.unitName);
                        }
                        try {
                            this.jtaDataSource = (DataSource)ctx.lookup(jtaDataSourceName);
                            break;
                        }
                        catch (NamingException ex) {
                            throw new DeploymentException("Could not find jta-data-source '" + jtaDataSourceName + "' for the persistence unit " + this.unitName, ex);
                        }
                    }
                    case RESOURCE_LOCAL: {
                        if (!PersistenceUnitInfoImpl.isNullOrEmpty(nonJtaDataSourceName)) break;
                        throw new DeploymentException("non-jta-data-source should be given for the persistence unit " + this.unitName);
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if (PersistenceUnitInfoImpl.isNullOrEmpty(nonJtaDataSourceName)) break block33;
                try {
                    this.nonJtaDataSource = (DataSource)ctx.lookup(nonJtaDataSourceName);
                }
                catch (NamingException ex) {
                    throw new DeploymentException("Could not find non-jta-data-source '" + nonJtaDataSourceName + "' for the persistence unit " + this.unitName, ex);
                }
            }
            catch (NamingException ex) {
                throw new DeploymentException("Internal error", ex);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        this.mappingFileNames = punit.getMappingFile();
        assert (this.mappingFileNames != null);
        List jarFiles = punit.getJarFile();
        this.jarFilesUrls = new ArrayList<URL>(jarFiles.size());
        if (jarFiles.size() > 0) {
            File parentFile = units.getPersistenceUnitRootFile().getParentFile();
            for (String jarPath : jarFiles) {
                File jarFile = new File(parentFile, jarPath.replace('/', File.separatorChar));
                try {
                    this.jarFilesUrls.add(jarFile.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        try {
            this.persistenceUnitRootUrl = units.getPersistenceUnitRootFile().toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        this.managedClassNames = punit.getClazz();
        if (punit.isSetExcludeUnlistedClasses()) {
            this.excludeUnlistedClasses = punit.isExcludeUnlistedClasses();
        }
        this.properties = new Properties();
        Persistence.PersistenceUnit.Properties propList = punit.getProperties();
        if (propList != null) {
            List propertyList = propList.getProperty();
            for (Persistence.PersistenceUnit.Properties.Property property : propertyList) {
                this.properties.put(property.getName(), property.getValue());
            }
        }
        this.classLoader = loader;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0 || s.trim().equals("");
    }

    public String getPersistenceUnitName() {
        return this.unitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFilesUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer transformer) {
        if (logger.isLoggable(JeusMessage_JPA._24_LEVEL)) {
            Object[] params = new String[]{transformer.getClass().getName(), this.unitName};
            logger.log(JeusMessage_JPA._24_LEVEL, JeusMessage_JPA._24, params);
        }
        if (this.classLoader instanceof TransformableClassLoader) {
            ((TransformableClassLoader)((Object)this.classLoader)).addTransformer(transformer);
        }
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.classLoader instanceof TransformableClassLoader) {
            return ((TransformableClassLoader)((Object)this.classLoader)).getNewTempClassLoader();
        }
        return this.classLoader;
    }
}

