/*
 * Decompiled with CFR 0.152.
 */
package jeus.persistence.container;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import jeus.container.ContainerExecutionContext;
import jeus.container.ExecutionModule;
import jeus.management.j2ee.DeploymentException;
import jeus.persistence.container.PersistenceProviders;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnitInfoImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JPA;
import jeus.xml.binding.j2ee.Persistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnits {
    static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.persistence");
    protected String persistenceUnitUri;
    protected File persistenceUnitRootFile;
    protected Persistence persistenceDescriptor;
    protected boolean isInitialized;
    protected Map<String, PersistenceUnit> persistenceUnitMap = new HashMap<String, PersistenceUnit>();

    public PersistenceUnits(String puUri, File puFile, Persistence persistenceDescriptor) {
        assert (puUri != null);
        assert (puFile != null);
        assert (persistenceDescriptor != null);
        this.persistenceUnitUri = puUri;
        this.persistenceUnitRootFile = puFile;
        this.persistenceDescriptor = persistenceDescriptor;
    }

    public String getPersistenceUnitUri() {
        return this.persistenceUnitUri;
    }

    public File getPersistenceUnitRootFile() {
        return this.persistenceUnitRootFile;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Persistence getPersistenceDescriptor() {
        return this.persistenceDescriptor;
    }

    public PersistenceUnit getPersistenceUnit(String unitName) {
        return this.persistenceUnitMap.get(unitName);
    }

    public Collection<PersistenceUnit> getPersistenceUnitCollection() {
        return Collections.unmodifiableCollection(this.persistenceUnitMap.values());
    }

    public void load(ClassLoader loader) throws DeploymentException {
        if (this.isInitialized) {
            return;
        }
        List punits = this.persistenceDescriptor.getPersistenceUnit();
        if (punits == null || punits.size() == 0) {
            return;
        }
        try {
            for (Persistence.PersistenceUnit punit : punits) {
                PersistenceProvider persistenceProvider;
                PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl(punit, this, loader);
                String providerClassName = pi.getPersistenceProviderClassName();
                try {
                    persistenceProvider = PersistenceProviders.createPersistenceProvider(loader, providerClassName);
                }
                catch (Exception ex) {
                    throw new DeploymentException("provider class " + providerClassName + " is not valid in persistence.xml", ex);
                }
                String unitName = pi.getPersistenceUnitName();
                Properties properties = PersistenceProviders.getDefaultPersistenceProperties();
                EntityManagerFactory emf = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, (Map)properties);
                logger.log(JeusMessage_JPA._25_LEVEL, JeusMessage_JPA._25, (Object)unitName);
                PersistenceUnit managed = new PersistenceUnit(this, unitName, emf);
                this.persistenceUnitMap.put(unitName, managed);
            }
            this.isInitialized = true;
        }
        catch (DeploymentException ex) {
            this.close();
            throw ex;
        }
        catch (Exception ex) {
            this.close();
            throw new DeploymentException(ex.getMessage(), ex);
        }
    }

    public void close() {
        if (this.persistenceUnitMap.size() == 0) {
            return;
        }
        for (PersistenceUnit pu : this.persistenceUnitMap.values()) {
            logger.log(JeusMessage_JPA._26_LEVEL, JeusMessage_JPA._26, (Object)pu.getUnitName());
            pu.close();
        }
    }

    static PersistenceUnit lookupPersistenceUnit(String puUri, String unitName) {
        ExecutionModule module = ContainerExecutionContext.getExecutionModule();
        assert (module != null);
        return module.lookupPersistenceUnit(puUri, unitName);
    }
}

