/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import jeus.rmi.http.HttpSendInputStream;
import jeus.rmi.http.HttpSendOutputStream;
import jeus.util.properties.JeusNetPropertyValues;
import sun.rmi.transport.proxy.RMISocketInfo;

class HttpSendSocket
extends Socket
implements RMISocketInfo {
    private String host;
    private int port;
    private URL url;
    private URLConnection conn = null;
    private InputStream in = null;
    private OutputStream out = null;
    private HttpSendInputStream inNotifier;
    private HttpSendOutputStream outNotifier;

    public HttpSendSocket(InetAddress address, int port) throws IOException {
        this(address.getHostName(), port);
    }

    public HttpSendSocket(String host, int port) throws IOException {
        this(host, port, new URL("http", host, port, "/"));
    }

    public HttpSendSocket(String host, int port, URL url) throws IOException {
        super((SocketImpl)null);
        this.host = host;
        this.port = port;
        this.url = url;
        this.conn = url.openConnection();
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(null, this);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public void setSoLinger(boolean on, int val) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public InetAddress getInetAddress() {
        try {
            return JeusNetPropertyValues.getByName((String)this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        return JeusNetPropertyValues.getLocalInetAddress();
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        this.inNotifier.deactivate();
        return this.inNotifier;
    }

    public OutputStream getOutputStream() throws IOException {
        this.outNotifier.deactivate();
        return this.outNotifier;
    }

    public synchronized void close() throws IOException {
        this.inNotifier.deactivate();
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.outNotifier.deactivate();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.conn != null) {
            this.conn = null;
        }
        if (this.url != null) {
            this.url = null;
        }
    }

    protected synchronized OutputStream writeNotify() throws IOException {
        if (this.conn == null) {
            throw new IOException("URLConnection(" + this.conn + ") is null");
        }
        this.out = this.conn.getOutputStream();
        return this.out;
    }

    protected synchronized InputStream readNotify() throws IOException {
        if (this.conn == null) {
            throw new IOException("URLConnection(" + this.conn + ") is null");
        }
        String contentType = this.conn.getContentType();
        if (contentType == null || contentType.indexOf("application/octet-stream") < 0) {
            throw new IOException("HTTP request failed");
        }
        this.in = this.conn.getInputStream();
        return this.in;
    }

    public boolean isReusable() {
        return false;
    }

    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }
}

