/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.server;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import jeus.ejb.bean.rmi.RMIInterceptorProvider;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.server.Dispatcher;
import jeus.rmi.impl.server.MarshalInputStream;
import jeus.rmi.impl.server.MethodInfo;
import jeus.rmi.impl.server.RemoteProxy;
import jeus.rmi.impl.server.UnicastRef;
import jeus.rmi.impl.server.Util;
import jeus.rmi.impl.server.WeakClassHashMap;
import jeus.rmi.impl.transport.LiveRef;
import jeus.rmi.impl.transport.StreamRemoteCall;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.tcp.TCPTransport;
import jeus.rmi.spec.RemoteCall;
import jeus.rmi.spec.ServerInterceptor;
import jeus.rmi.spec.server.RemoteRef;
import jeus.rmi.spec.server.RemoteStub;
import jeus.rmi.spec.server.ServerRef;
import jeus.rmi.spec.server.Skeleton;
import jeus.util.properties.JeusRMIProperties;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final Log serverRefLog = Log.getLog("jeus.rmi.server.ref", "transport", RemoteProxy.logLevel);
    public static final boolean logCalls = JeusRMIProperties.ENABLE_SERVER_LOG;
    public static final Log callLog = Log.getLog("jeus.rmi.server.call", "RMI", logCalls);
    private static final long serialVersionUID = 7555603515308070373L;
    private static final boolean wantExceptionLog = JeusRMIProperties.ENABLE_SERVER_EXCEPTION_LOG;
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces = JeusRMIProperties.ENABLE_SERVER_SUPRESS_TRACE_LOG;
    private transient Skeleton skel;
    private transient Map hashToMethod_Map = null;
    private static final WeakClassHashMap hashToMethod_Maps = new HashToMethod_Maps();
    private static Map withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef ref) {
        super(ref);
    }

    public UnicastServerRef(int port) {
        super(new LiveRef(port));
    }

    public UnicastServerRef(boolean forceStubUse) {
        this(0);
        this.forceStubUse = forceStubUse;
    }

    public Remote exportObject(Remote impl, Object data) throws RemoteException {
        return this.exportObject(impl, data, -1);
    }

    public Remote exportObject(Remote impl, Object data, int clusterType) throws RemoteException {
        return this.innerExportObject(impl, clusterType);
    }

    private Remote innerExportObject(Remote impl, int clusterType) throws RemoteException {
        Remote stub;
        Class<?> implClass = impl.getClass();
        try {
            stub = Util.createProxy(implClass, this.getClientRef(), this.forceStubUse, clusterType);
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("remote object implements illegal remote interface", e);
        }
        if (stub instanceof RemoteStub) {
            this.setSkeleton(impl);
        }
        Target target = new Target(impl, this, stub, this.ref.getObjID());
        this.ref.exportObject(target);
        this.hashToMethod_Map = hashToMethod_Maps.getMap(implClass);
        return stub;
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote impl) throws RemoteException {
        if (!withoutSkeletons.containsKey(impl.getClass())) {
            try {
                this.skel = Util.createSkeleton(impl);
            }
            catch (SkeletonNotFoundException e) {
                withoutSkeletons.put(impl.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Remote obj, RemoteCall call, ObjectInput in, int num, long op) throws IOException {
        if (obj instanceof RMIInterceptorProvider) {
            call.setServerIntercepter(((RMIInterceptorProvider)((Object)obj)).getServerInterceptor());
        }
        ServerInterceptor serverIntercepter = call.getServerIntercepter();
        StreamRemoteCall sCall = (StreamRemoteCall)call;
        try {
            Object result;
            boolean isVoidReturn;
            Method method;
            block34: {
                boolean isSimpleParam;
                block32: {
                    block33: {
                        MethodInfo methodInfo = (MethodInfo)this.hashToMethod_Map.get(new Long(op));
                        method = methodInfo.getMethod();
                        if (method == null) {
                            throw new UnmarshalException("invalid method hash");
                        }
                        isVoidReturn = methodInfo.isVoidReturn();
                        isSimpleParam = methodInfo.isSimpleParam();
                        byte returnTypeNumber = methodInfo.getReturn_type_number();
                        call.setInfo(method, returnTypeNumber, isVoidReturn, isSimpleParam);
                        try {
                            if (num < 0) break block32;
                            if (this.skel == null) break block33;
                            this.oldDispatch(obj, call, num, in, op);
                            return;
                        }
                        catch (Exception readEx) {
                            throw new UnmarshalException("error unmarshalling call header", readEx);
                        }
                    }
                    throw new UnmarshalException("skeleton class not found but required for client version");
                }
                if (in != null) {
                    MarshalInputStream marshalStream = (MarshalInputStream)in;
                    marshalStream.skipDefaultResolveClass();
                }
                Class<?>[] types = method.getParameterTypes();
                Object[] params = new Object[types.length];
                try {
                    if (isSimpleParam) {
                        DataInput dis = call.getDataInputStream();
                        for (int i = 0; i < types.length; ++i) {
                            params[i] = UnicastServerRef.unmarshalDataValue(types[i], dis);
                        }
                    } else {
                        in = call.getInputStream();
                        for (int i = 0; i < types.length; ++i) {
                            params[i] = UnicastServerRef.unmarshalValue(types[i], in);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UnmarshalException("error unmarshalling arguments", e);
                }
                catch (ClassNotFoundException e) {
                    throw new UnmarshalException("error unmarshalling arguments", e);
                }
                try {
                    if (serverIntercepter != null) {
                        serverIntercepter.intercept(isSimpleParam ? call.getDataInputStream() : call.getInputStream(), sCall);
                        try {
                            result = method.invoke((Object)obj, params);
                            break block34;
                        }
                        catch (InvocationTargetException e) {
                            Throwable ex = e.getTargetException();
                            serverIntercepter.exceptionOccurred(ex, sCall);
                            throw ex;
                        }
                        catch (Throwable e) {
                            serverIntercepter.exceptionOccurred(e, sCall);
                            throw e;
                        }
                    }
                    result = method.invoke((Object)obj, params);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            try {
                ObjectOutput out = call.getResultStream(true);
                if (!isVoidReturn) {
                    Class<?> rtype = method.getReturnType();
                    UnicastServerRef.marshalValue(rtype, result, out);
                }
            }
            catch (IOException ex) {
                throw new MarshalException("error marshalling return", ex);
            }
        }
        catch (Throwable e2) {
            RemoteException e2;
            this.logCallException(e2);
            ((StreamRemoteCall)call).setServerException(e2);
            if (e2 instanceof Error) {
                e2 = new ServerError("Error occurred in server thread", (Error)e2);
            } else if (e2 instanceof RemoteException) {
                e2 = new ServerException("RemoteException occurred in server thread", (Exception)e2);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(e2);
            }
        }
        finally {
            call.releaseInputStream();
            call.releaseOutputStream();
        }
    }

    public void oldDispatch(Remote obj, RemoteCall call, int op, ObjectInput in, long hash) throws IOException {
        block5: {
            try {
                this.logCall(obj, this.skel.getOperations()[op]);
                this.skel.dispatch(obj, call, -1, hash);
            }
            catch (Throwable e2) {
                RemoteException e2;
                this.logCallException(e2);
                ((StreamRemoteCall)call).setServerException(e2);
                if (e2 instanceof Error) {
                    e2 = new ServerError("Error occurred in server thread", (Error)e2);
                } else if (e2 instanceof RemoteException) {
                    e2 = new ServerException("RemoteException occurred in server thread", (Exception)e2);
                }
                if (!suppressStackTraces) break block5;
                UnicastServerRef.clearStackTraces(e2);
            }
        }
    }

    public static void clearStackTraces(Throwable t) {
        StackTraceElement[] empty = new StackTraceElement[]{};
        while (t != null) {
            t.setStackTrace(empty);
            t = t.getCause();
        }
    }

    private void logCall(Remote obj, Object method) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String clientHost;
            try {
                clientHost = this.getClientHost();
            }
            catch (ServerNotActiveException snae) {
                clientHost = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + clientHost + ": " + obj.getClass().getName() + this.ref.getObjID().toString() + ": " + method + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable e) {
        if (callLog.isLoggable(Log.BRIEF)) {
            String clientHost = "";
            try {
                clientHost = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, clientHost + "exception: ", e);
        }
        if (wantExceptionLog) {
            PrintStream log;
            PrintStream printStream = log = System.err;
            synchronized (printStream) {
                log.println();
                log.println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                e.printStackTrace(log);
            }
        }
    }

    public String getRefClass(ObjectOutput out) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    private static class HashToMethod_Maps
    extends WeakClassHashMap {
        HashToMethod_Maps() {
        }

        protected Map createMap(Class remoteClass) {
            HashMap<Long, MethodInfo> map = new HashMap<Long, MethodInfo>();
            for (Class cl = remoteClass; cl != null; cl = cl.getSuperclass()) {
                Class<?>[] interfaces = cl.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!Remote.class.isAssignableFrom(interfaces[i])) continue;
                    Method[] methods = interfaces[i].getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        final Method m = methods[j];
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                m.setAccessible(true);
                                return null;
                            }
                        });
                        long hash = Util.computeMethodHash(m);
                        map.put(new Long(hash), new MethodInfo(m));
                    }
                }
            }
            return map;
        }
    }
}

