/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import jeus.rmi.impl.runtime.NewThreadAction;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusRMIProperties;

public class FQDN
implements Runnable {
    private String reverseLookup;
    private String hostAddress;

    private FQDN(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String attemptFQDN(InetAddress localAddr) {
        String hostName = localAddr.getHostName();
        if (hostName.indexOf(46) < 0) {
            String hostAddress = localAddr.getHostAddress();
            FQDN f = new FQDN(hostAddress);
            int nameServiceTimeOut = JeusRMIProperties.LOCAL_HOSTNAME_TO;
            try {
                FQDN fQDN = f;
                synchronized (fQDN) {
                    f.getFQDN();
                    f.wait(nameServiceTimeOut);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            hostName = f.getHost();
            if (hostName == null || hostName.equals("") || hostName.indexOf(46) < 0) {
                hostName = hostAddress;
            }
        }
        return hostName;
    }

    private void getFQDN() {
        Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "FQDN Finder", true));
        t.start();
    }

    private synchronized String getHost() {
        return this.reverseLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String name = null;
        try {
            name = JeusNetPropertyValues.getByName((String)this.hostAddress).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            FQDN fQDN = this;
            synchronized (fQDN) {
                this.reverseLookup = name;
                this.notify();
            }
        }
        finally {
            FQDN fQDN = this;
            synchronized (fQDN) {
                this.reverseLookup = name;
                this.notify();
            }
        }
    }
}

