/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.net.InetAddress;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import jeus.rmi.impl.transport.Channel;
import jeus.rmi.impl.transport.FQDN;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.support.EndpointSupport;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusRMIProperties;
import sun.rmi.runtime.Log;

public abstract class ServerEndpoint
extends EndpointSupport {
    protected Transport transport = null;
    protected static String localHost;
    protected static boolean localHostKnown;

    public ServerEndpoint(String host, int port) {
        super(host, port);
    }

    public ServerEndpoint(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        super(host, port, csf, ssf);
    }

    public Channel getChannel() {
        return null;
    }

    static {
        localHostKnown = true;
        localHost = JeusRMIProperties.SERVER_HOSTNAME;
        if (localHost == null) {
            try {
                InetAddress localAddr = JeusNetPropertyValues.getLocalInetAddress();
                byte[] raw = localAddr.getAddress();
                if (raw[0] == 127 && raw[1] == 0 && raw[2] == 0 && raw[3] == 1) {
                    localHostKnown = false;
                }
                localHost = JeusRMIProperties.USE_LOCAL_HOSTNAME ? FQDN.attemptFQDN(localAddr) : localAddr.getHostAddress();
            }
            catch (Exception e) {
                localHostKnown = false;
                localHost = null;
            }
        }
        if (Transport.transportLog.isLoggable(Log.BRIEF)) {
            Transport.transportLog.log(Log.BRIEF, "localHostKnown = " + localHostKnown + ", localHost = " + localHost);
        }
    }
}

