/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net;

import java.io.IOException;
import java.rmi.ConnectIOException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Map;
import jeus.io.helper.IOComponentCreator;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.rmi.impl.transport.ClientEndpoint;
import jeus.rmi.impl.transport.ClientEndpointKey;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.net.JeusChannel;
import jeus.rmi.impl.transport.net.JeusConnection;
import jeus.rmi.impl.transport.net.MultiThreadAccessJeusConnection;
import jeus.rmi.impl.transport.net.help.RMIClientConnectionListenerFactory;
import jeus.rmi.impl.transport.net.help.RMIIOComponentCreator;
import jeus.rmi.impl.transport.net.help.RMIPropertiesConstant;
import jeus.util.ByteUtil;
import jeus.util.properties.JeusRMIProperties;

public class JeusClientEndpoint
extends ClientEndpoint {
    private static final String RMI_NAME = "JEUS-RMI";
    private Endpoint endpoint;
    private static byte[] opConPiggyBack = new byte[7];

    public JeusClientEndpoint(String host, int port) {
        this(host, port, null);
    }

    public JeusClientEndpoint(String host, int port, RMIClientSocketFactory csf) {
        super(host, port, csf, null);
        this.channel = new JeusChannel(this);
        RMIIOComponentCreator iocpCreator = new RMIIOComponentCreator(RMIPropertiesConstant.ioType, csf, this.ssf, RMI_NAME, JeusRMIProperties.CLIENT_NUM);
        this.endpoint = new Endpoint(RMI_NAME, (IOComponentCreator)iocpCreator, (SocketID)new NoListenID(), (ConnectionListenerFactory)new RMIClientConnectionListenerFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JeusClientEndpoint getLocalEndpoint(String host, int port, RMIClientSocketFactory csf) {
        JeusClientEndpoint endpoint;
        Map map = localEndpoints;
        synchronized (map) {
            ClientEndpointKey key = new ClientEndpointKey(host, port, csf);
            endpoint = (JeusClientEndpoint)localEndpoints.get(key);
            if (endpoint == null) {
                endpoint = new JeusClientEndpoint(host, port, csf);
                localEndpoints.put(key, endpoint);
            }
        }
        return endpoint;
    }

    public Connection createConnection() throws ConnectIOException {
        SocketStream socketStream = null;
        try {
            socketStream = this.endpoint.getSocketStream((SocketID)new NodeInfo(this.host, this.port), 1, (Object)opConPiggyBack, 0, 0);
        }
        catch (ConnectorException e) {
            throw new ConnectIOException("Exception creating connection to: " + this.host, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ConnectIOException("Exception converting magic number and version", e);
        }
        return JeusRMIProperties.SINGLE_THREAD_CLIENT ? new JeusConnection(socketStream) : new MultiThreadAccessJeusConnection(socketStream);
    }

    static {
        System.arraycopy(ByteUtil.convertToByte((int)1246907721), 0, opConPiggyBack, 0, 4);
        System.arraycopy(ByteUtil.convertToBytes((short)2), 0, opConPiggyBack, 4, 2);
    }
}

