/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import jeus.io.helper.IOComponentCreator;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.impl.NodeInfo;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.ServerEndpoint;
import jeus.rmi.impl.transport.ServerEndpointKey;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.net.JeusTransport;
import jeus.rmi.impl.transport.net.help.RMIIOComponentCreator;
import jeus.rmi.impl.transport.net.help.RMIPropertiesConstant;
import jeus.rmi.impl.transport.net.help.RMIServerConnectionListenerFactory;
import jeus.util.properties.JeusRMIProperties;

public class JeusServerEndpoint
extends ServerEndpoint {
    private static final String RMI_NAME = "JEUS-RMI";
    private static Endpoint endpoint;

    public JeusServerEndpoint(String host, int port) {
        this(host, port, null, null);
    }

    public JeusServerEndpoint(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        super(host, port, csf, ssf);
        RMIIOComponentCreator iocpCreator = new RMIIOComponentCreator(RMIPropertiesConstant.ioType, csf, ssf, RMI_NAME, JeusRMIProperties.CLIENT_NUM);
        endpoint = new Endpoint(RMI_NAME, (IOComponentCreator)iocpCreator, (SocketID)new NodeInfo(host, port), (ConnectionListenerFactory)new RMIServerConnectionListenerFactory());
    }

    public void exportObject(Target target) throws RemoteException {
        try {
            endpoint.export();
            if (this.port == 0) {
                JeusServerEndpoint.setDefaultPort(endpoint.getServerSocketPort(), this.csf, this.ssf);
            }
            this.transport.exportObject(target);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultPort(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        ServerEndpointKey key = new ServerEndpointKey(0, ssf, csf);
        Map map = localEndpoints;
        synchronized (map) {
            JeusServerEndpoint ep = (JeusServerEndpoint)localEndpoints.get(key);
            if (ep.port != 0) {
                return;
            }
            ep.port = port;
            ServerEndpointKey newKey = new ServerEndpointKey(port, ssf, csf);
            localEndpoints.remove(key);
            localEndpoints.put(newKey, ep);
            if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                Transport.transportLog.log(Log.BRIEF, "default port for server socket factory " + ssf + " and client socket factory " + csf + " set to " + port);
            }
        }
    }

    public static JeusServerEndpoint getLocalEndpoint(int port) {
        return JeusServerEndpoint.getLocalEndpoint(port, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JeusServerEndpoint getLocalEndpoint(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        JeusServerEndpoint endpoint;
        Map map = localEndpoints;
        synchronized (map) {
            ServerEndpointKey key = new ServerEndpointKey(port, ssf, csf);
            endpoint = (JeusServerEndpoint)localEndpoints.get(key);
            if (endpoint == null) {
                endpoint = new JeusServerEndpoint(localHost, port, csf, ssf);
                endpoint.transport = new JeusTransport(endpoint);
                localEndpoints.put(key, endpoint);
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "created local endpoint for socket factory " + ssf + " on port " + port);
                }
            }
        }
        return endpoint;
    }
}

