/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net.help;

import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import java.util.logging.Level;
import jeus.net.AcceptorConnectionListenerSupport;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.rmi.impl.transport.StreamRemoteCall;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.net.JeusConnection;
import jeus.rmi.impl.transport.net.JeusServerConnection;
import jeus.util.ByteUtil;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.properties.JeusRMIProperties;

public class RMIAcceptorConnectionListener
extends AcceptorConnectionListenerSupport {
    private static byte[] protocolAck = new byte[]{78};
    private static Executor executor;
    private static final int connectionReadTimeout;

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " rmi jeus connection from {0} is allowed", (Object)sockStream);
        }
        Socket socket = sockStream.getSocket();
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (connectionReadTimeout > 0) {
                socket.setSoTimeout(connectionReadTimeout);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] header = (byte[])piggybackedData;
        int magic = ByteUtil.convertToInt((byte[])header);
        int version = ByteUtil.convertToUnsignedShort((byte[])header, (int)4);
        byte protocol = header[6];
        if (protocol == 75) {
            packet.setData((Object)protocolAck);
            JeusServerConnection.setProtocol(sockStream, protocol);
        }
        if (magic != 1246907721 || version != 2) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "destroy the socketStream because magic and version are different from peer's : ", (Object)sockStream);
            }
            sockStream.destroy();
        } else {
            sockStream.write((Object)packet);
        }
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "rmi jeus connection from {0} is received message", (Object)sockStream);
        }
        if (!(obj instanceof byte[])) {
            throw new IOException("msg is not byte[] " + obj);
        }
        byte[] data = (byte[])obj;
        JeusServerConnection conn = JeusServerConnection.getConnection(sockStream);
        conn.setByteArrayInputStream(data);
        byte msgType = conn.getDataInput().readByte();
        switch (msgType) {
            case 2: {
                byte service = conn.getDataInput().readByte();
                if (service == 80) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "rmi jeus connection from {0} is received a Call message", (Object)sockStream);
                    }
                    StreamRemoteCall call = new StreamRemoteCall(conn);
                    Transport.serviceCall(call);
                    break;
                }
                if (service == 82) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "rmi jeus connection from {0} is received a Ping message", (Object)sockStream);
                    }
                    sockStream.writeReply(new byte[]{83});
                    break;
                }
            }
            default: {
                throw new IOException("unknown transport op " + data[0]);
            }
        }
        JeusServerConnection.free(sockStream, conn);
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        if (JeusRMIProperties.ENABLE_SERVER_PROCESS_POOL) {
            executor.execute(messageProcessor);
        } else {
            messageProcessor.run();
        }
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        Vector cons;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "rmi jeus connection from {0} is closed", (Object)socketStream);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
        if ((cons = JeusServerConnection.getConnections(socketStream)) == null) {
            return;
        }
        for (int i = 0; i < cons.size(); ++i) {
            JeusConnection con = (JeusConnection)cons.elementAt(i);
            try {
                con.closeInternal();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        connectionReadTimeout = JeusRMIProperties.SERVER_READ_TO;
        if (JeusRMIProperties.ENABLE_SERVER_PROCESS_POOL) {
            executor = PooledExecutorFactory.createPooledExecutor((String)"RMIAcceptorConnectionListener", (int)JeusRMIProperties.SERVER_PROCESS_POOL_SIZE);
        }
    }
}

