/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.Socket;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.Channel;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.support.ConnectionSupport;
import jeus.rmi.impl.transport.tcp.TCPChannel;
import sun.rmi.transport.proxy.RMISocketInfo;

public abstract class TCPConnection
extends ConnectionSupport {
    private Socket socket;
    private Channel channel;
    private InputStream in = null;
    private OutputStream out = null;
    private DataOutput dout;
    private DataInput din;
    private long roundtrip = 5L;

    TCPConnection(TCPChannel ch, Socket s, InputStream in, OutputStream out) {
        this.socket = s;
        this.channel = ch;
        this.in = in;
        this.out = out;
    }

    TCPConnection(TCPChannel ch, InputStream in, OutputStream out) {
        this(ch, null, in, out);
    }

    TCPConnection(TCPChannel ch, Socket s) {
        this(ch, s, null, null);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.out;
    }

    public void releaseOutputStream() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        return this.in;
    }

    public void releaseInputStream() {
    }

    public boolean isReusable() {
        if (this.socket != null && this.socket instanceof jeus.rmi.impl.transport.proxy.RMISocketInfo) {
            return ((jeus.rmi.impl.transport.proxy.RMISocketInfo)((Object)this.socket)).isReusable();
        }
        if (this.socket != null && this.socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)this.socket).isReusable();
        }
        return true;
    }

    public boolean isDead() {
        OutputStream o;
        InputStream i;
        long start = System.currentTimeMillis();
        if (this.roundtrip > 0L && start < this.lastuse + this.roundtrip) {
            return false;
        }
        try {
            i = this.getInputStream();
            o = this.getOutputStream();
        }
        catch (IOException e) {
            return true;
        }
        int response = 0;
        try {
            o.write(82);
            o.flush();
            response = i.read();
        }
        catch (IOException ex) {
            Transport.transportLog.log(Log.VERBOSE, "exception: ", ex);
            Transport.transportLog.log(Log.BRIEF, "server ping failed");
            return true;
        }
        if (response == 83) {
            this.roundtrip = (System.currentTimeMillis() - start) * 2L;
            return false;
        }
        if (Transport.transportLog.isLoggable(Log.BRIEF)) {
            Transport.transportLog.log(Log.BRIEF, response == -1 ? "server has been deactivated" : "server protocol error: ping response = " + response);
        }
        return true;
    }

    public void close() throws IOException {
        Transport.transportLog.log(Log.BRIEF, "close connection");
        if (this.socket != null) {
            this.socket.close();
        } else {
            this.in.close();
            this.out.close();
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public abstract ObjectOutput getObjectOutput() throws IOException;

    public abstract ObjectInput getObjectInput(ClassLoader var1) throws IOException;

    public DataOutput getDataOutput() throws IOException {
        if (this.dout == null) {
            this.dout = new DataOutputStream(this.getOutputStream());
        }
        return this.dout;
    }

    public DataInput getDataInput() throws IOException {
        if (this.din == null) {
            this.din = new DataInputStream(this.getInputStream());
        }
        return this.din;
    }
}

