/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.ServerEndpoint;
import jeus.rmi.impl.transport.ServerEndpointKey;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.tcp.TCPTransport;

public class TCPServerEndpoint
extends ServerEndpoint {
    public TCPServerEndpoint(String host, int port) {
        super(host, port);
    }

    public TCPServerEndpoint(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        super(host, port, csf, ssf);
    }

    public void exportObject(Target target) throws RemoteException {
        this.transport.exportObject(target);
    }

    public static TCPServerEndpoint getLocalEndpoint(int port) {
        return TCPServerEndpoint.getLocalEndpoint(port, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCPServerEndpoint getLocalEndpoint(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        TCPServerEndpoint endpoint;
        Map map = localEndpoints;
        synchronized (map) {
            ServerEndpointKey key = new ServerEndpointKey(port, ssf, csf);
            endpoint = (TCPServerEndpoint)localEndpoints.get(key);
            if (endpoint == null) {
                endpoint = new TCPServerEndpoint(localHost, port, csf, ssf);
                endpoint.transport = new TCPTransport(endpoint);
                localEndpoints.put(key, endpoint);
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "created local endpoint for socket factory " + ssf + " on port " + port);
                }
            }
        }
        return endpoint;
    }

    ServerSocket newServerSocket() throws IOException {
        RMIServerSocketFactory serverFactory;
        if (Transport.transportLog.isLoggable(Log.VERBOSE)) {
            Transport.transportLog.log(Log.VERBOSE, "creating server socket on " + this);
        }
        if ((serverFactory = this.ssf) == null) {
            serverFactory = TCPServerEndpoint.chooseFactory();
        }
        ServerSocket server = serverFactory.createServerSocket(this.port);
        if (this.port == 0) {
            TCPServerEndpoint.setDefaultPort(server.getLocalPort(), this.csf, this.ssf);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultPort(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        ServerEndpointKey key = new ServerEndpointKey(0, ssf, csf);
        Map map = localEndpoints;
        synchronized (map) {
            TCPServerEndpoint ep = (TCPServerEndpoint)localEndpoints.get(key);
            if (ep.port != 0) {
                return;
            }
            ep.port = port;
            ServerEndpointKey newKey = new ServerEndpointKey(port, ssf, csf);
            localEndpoints.remove(key);
            localEndpoints.put(newKey, ep);
            if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                Transport.transportLog.log(Log.BRIEF, "default port for server socket factory " + ssf + " and client socket factory " + csf + " set to " + port);
            }
        }
    }
}

