/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import jeus.rmi.spec.registry.LocateRegistry;
import jeus.rmi.spec.registry.Registry;

public final class Naming {
    private Naming() {
    }

    public static Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (parsed.name == null) {
            return registry;
        }
        return registry.lookup(parsed.name);
    }

    public static void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (obj == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.bind(parsed.name, obj);
    }

    public static void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        registry.unbind(parsed.name);
    }

    public static void rebind(String name, Remote obj) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (obj == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.rebind(parsed.name, obj);
    }

    public static String[] list(String name) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        String prefix = "";
        if (parsed.port > 0 || !parsed.host.equals("")) {
            prefix = prefix + "//" + parsed.host;
        }
        if (parsed.port > 0) {
            prefix = prefix + ":" + parsed.port;
        }
        prefix = prefix + "/";
        String[] names = registry.list();
        for (int i = 0; i < names.length; ++i) {
            names[i] = prefix + names[i];
        }
        return names;
    }

    private static Registry getRegistry(ParsedNamingURL parsed) throws RemoteException {
        return LocateRegistry.getRegistry(parsed.host, parsed.port);
    }

    private static ParsedNamingURL parseURL(String str) throws MalformedURLException {
        try {
            int port;
            String host;
            URI uri = new URI(str);
            if (uri.getFragment() != null) {
                throw new MalformedURLException("invalid character, '#', in URL name: " + str);
            }
            if (uri.getQuery() != null) {
                throw new MalformedURLException("invalid character, '?', in URL name: " + str);
            }
            if (uri.getUserInfo() != null) {
                throw new MalformedURLException("invalid character, '@', in URL host: " + str);
            }
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.equals("rmi")) {
                throw new MalformedURLException("invalid URL scheme: " + str);
            }
            String name = uri.getPath();
            if (name != null) {
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (name.length() == 0) {
                    name = null;
                }
            }
            if ((host = uri.getHost()) == null) {
                String authority;
                host = "";
                if (uri.getPort() == -1 && (authority = uri.getAuthority()) != null && authority.startsWith(":")) {
                    authority = "localhost" + authority;
                    uri = new URI(null, authority, null, null, null);
                }
            }
            if ((port = uri.getPort()) == -1) {
                port = 1099;
            }
            return new ParsedNamingURL(host, port, name);
        }
        catch (URISyntaxException ex) {
            throw (MalformedURLException)new MalformedURLException("invalid URL string: " + str).initCause(ex);
        }
    }

    private static class ParsedNamingURL {
        String host;
        int port;
        String name;

        ParsedNamingURL(String host, int port, String name) {
            this.host = host;
            this.port = port;
            this.name = name;
        }
    }
}

