/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import jeus.rmi.impl.server.LoaderHandler;
import jeus.rmi.spec.server.RMIClassLoaderSpi;
import sun.misc.Service;

public class RMIClassLoader {
    private static final RMIClassLoaderSpi defaultProvider = RMIClassLoader.newDefaultProviderInstance();
    private static final RMIClassLoaderSpi provider = (RMIClassLoaderSpi)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return RMIClassLoader.initializeProvider();
        }
    });

    private RMIClassLoader() {
    }

    public static Class loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass((String)null, name);
    }

    public static Class loadClass(URL codebase, String name) throws MalformedURLException, ClassNotFoundException {
        return provider.loadClass(codebase != null ? codebase.toString() : null, name, null);
    }

    public static Class loadClass(String codebase, String name) throws MalformedURLException, ClassNotFoundException {
        return provider.loadClass(codebase, name, null);
    }

    public static Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return provider.loadClass(codebase, name, defaultLoader);
    }

    public static Class loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws ClassNotFoundException, MalformedURLException {
        return provider.loadProxyClass(codebase, interfaces, defaultLoader);
    }

    public static ClassLoader getClassLoader(String codebase) throws MalformedURLException, SecurityException {
        return provider.getClassLoader(codebase);
    }

    public static String getClassAnnotation(Class cl) {
        return provider.getClassAnnotation(cl);
    }

    public static RMIClassLoaderSpi getDefaultProviderInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setFactory"));
        }
        return defaultProvider;
    }

    public static Object getSecurityContext(ClassLoader loader) {
        return LoaderHandler.getSecurityContext(loader);
    }

    private static RMIClassLoaderSpi newDefaultProviderInstance() {
        return new RMIClassLoaderSpi(){

            public Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
                return LoaderHandler.loadClass(codebase, name, defaultLoader);
            }

            public Class loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
                return LoaderHandler.loadProxyClass(codebase, interfaces, defaultLoader);
            }

            public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
                return LoaderHandler.getClassLoader(codebase);
            }

            public String getClassAnnotation(Class cl) {
                return LoaderHandler.getClassAnnotation(cl);
            }
        };
    }

    private static RMIClassLoaderSpi initializeProvider() {
        String providerClassName = System.getProperty("jeus.rmi.spec.server.RMIClassLoaderSpi");
        if (providerClassName != null) {
            if (providerClassName.equals("default")) {
                return defaultProvider;
            }
            try {
                Class<?> providerClass = Class.forName(providerClassName, false, ClassLoader.getSystemClassLoader());
                return (RMIClassLoaderSpi)providerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (ClassCastException e) {
                LinkageError error = new LinkageError("provider class not assignable to RMIClassLoaderSpi");
                error.initCause(e);
                throw error;
            }
        }
        Iterator iter = Service.providers(RMIClassLoaderSpi.class, (ClassLoader)ClassLoader.getSystemClassLoader());
        if (iter.hasNext()) {
            try {
                return (RMIClassLoaderSpi)iter.next();
            }
            catch (ClassCastException e) {
                LinkageError error = new LinkageError("provider class not assignable to RMIClassLoaderSpi");
                error.initCause(e);
                throw error;
            }
        }
        return defaultProvider;
    }
}

