/*
 * Decompiled with CFR 0.152.
 */
package jeus.schedule;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import jeus.descriptor.jeusserver.JobDescriptor;
import jeus.schedule.JEUSScheduler;
import jeus.schedule.JeusSchedulerException;
import jeus.schedule.Logger;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Scheduler;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.jeusDD.PoolingType;

public final class ContainerSchedulerService {
    public static final JeusLogger logger = Logger.logger;
    private volatile JEUSScheduler scheduler;
    private volatile boolean started = false;
    private volatile boolean exported = false;

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void startNodeService(PoolingType poolType, JobDescriptor jobDescriptor) throws JeusException {
        this.startService(JEUSScheduler.NODE_SCOPE, poolType, jobDescriptor);
    }

    public synchronized void startContainerService(PoolingType poolType, JobDescriptor jobDescriptor) throws JeusException {
        this.startService(JEUSScheduler.CONTAINER_SCOPE, poolType, jobDescriptor);
    }

    private synchronized void startService(Integer scope, PoolingType poolType, JobDescriptor jobDescriptor) throws JeusException {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            JEUSScheduler.init(scope, poolType.getMin(), poolType.getMax(), poolType.getPeriod());
            this.scheduler = new JEUSScheduler(scope);
            if (scope.equals(JEUSScheduler.NODE_SCOPE)) {
                this.export();
            }
            if (logger.isLoggable(JeusMessage_Manager._182_LEVEL)) {
                logger.log(JeusMessage_Manager._182_LEVEL, JeusMessage_Manager._182);
            }
        }
        catch (Throwable e) {
            this.stopService(scope);
            throw new JeusException(JeusMessage_Manager.MGR_70, e);
        }
        try {
            this.registerSchedule(jobDescriptor);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Scheduler._100_LEVEL)) {
                logger.log(JeusMessage_Scheduler._100_LEVEL, JeusMessage_Scheduler._100, ex);
            }
            this.stopService(scope);
            throw new JeusException(JeusMessage_Scheduler._100, ex);
        }
    }

    public synchronized void stopNodeService() {
        this.stopService(JEUSScheduler.NODE_SCOPE);
    }

    public synchronized void stopContainerService() {
        this.stopService(JEUSScheduler.CONTAINER_SCOPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopService(Integer scope) {
        try {
            JEUSScheduler.stop(scope);
            if (this.scheduler != null) {
                this.unexport();
                this.scheduler = null;
            }
        }
        catch (Throwable ex1) {
            if (logger.isLoggable(JeusMessage_Manager._183_LEVEL)) {
                logger.log(JeusMessage_Manager._183_LEVEL, JeusMessage_Manager._183, ex1);
            }
        }
        finally {
            this.started = false;
        }
    }

    private void export() throws JeusSchedulerException {
        try {
            if (!this.exported) {
                UnicastRemoteObject.exportObject((Remote)((Object)this.scheduler), JeusManagerPropertyValues.getDefaultRMIPort());
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("jeus.jndi.jns.replicatebindings", "false");
                env.put("jeus.jndi.jns.forcedbindings", "true");
                InitialContext ctx = new InitialContext(env);
                ctx.rebind("jeus_service/Scheduler", (Object)this.scheduler);
                ctx.close();
                this.exported = true;
                if (Logger.logger.isLoggable(JeusMessage_Scheduler._22_LEVEL)) {
                    Logger.logger.log(JeusMessage_Scheduler._22_LEVEL, JeusMessage_Scheduler._22, (Object)"jeus_service/Scheduler");
                }
            }
        }
        catch (Throwable ex) {
            throw new JeusSchedulerException(JeusMessage_Scheduler._2, ex);
        }
    }

    private void unexport() throws JeusSchedulerException {
        try {
            if (this.exported) {
                Hashtable<String, String> envs = new Hashtable<String, String>();
                envs.put("jeus.jndi.jns.replicatebindings", "false");
                InitialContext ctx = new InitialContext(envs);
                ctx.unbind("jeus_service/Scheduler");
                ctx.close();
                if (Logger.logger.isLoggable(JeusMessage_Scheduler._23_LEVEL)) {
                    Logger.logger.log(JeusMessage_Scheduler._23_LEVEL, JeusMessage_Scheduler._23);
                }
            }
        }
        catch (Throwable ex) {
            throw new JeusSchedulerException(JeusMessage_Scheduler._4, ex);
        }
        finally {
            this.exported = false;
        }
    }

    private void registerSchedule(JobDescriptor desc) throws JeusSchedulerException, RemoteException {
        Vector<String> classNameList = desc.getClassNameList();
        Vector<Calendar> beginTimeList = desc.getBeginTimeList();
        Vector<Calendar> endTimeList = desc.getEndTimeList();
        Vector<Long> intervalList = desc.getIntervalList();
        Vector<Long> countList = desc.getCountList();
        for (int i = 0; i < classNameList.size(); ++i) {
            long maxcount;
            String className = classNameList.get(i);
            long period = intervalList.get(i);
            Calendar beginTime = beginTimeList.get(i);
            Date start = null;
            Date first = null;
            if (beginTime != null) {
                start = beginTime.getTime();
                first = this.scheduler.getTimeAfterNow(start, period);
            }
            Calendar endTime = endTimeList.get(i);
            Date end = null;
            if (endTime != null) {
                end = endTime.getTime();
            }
            if ((maxcount = countList.get(i).longValue()) < 0L) {
                maxcount = -1L;
            }
            if (first != null) {
                this.scheduler.registerScheduleAtFixedRate(className, first, period, end, maxcount, false);
            } else {
                this.scheduler.registerScheduleAtFixedRate(className, 0L, period, end, maxcount, false);
            }
            if (!logger.isLoggable(JeusMessage_Scheduler._16_LEVEL)) continue;
            logger.log(JeusMessage_Scheduler._16_LEVEL, JeusMessage_Scheduler._16, (Object)classNameList.get(i));
        }
    }
}

