/*
 * Decompiled with CFR 0.152.
 */
package jeus.schedule;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.Hashtable;
import jeus.schedule.JeusSchedulerException;
import jeus.schedule.Logger;
import jeus.schedule.RemoteSchedule;
import jeus.schedule.Schedule;
import jeus.schedule.ScheduleController;
import jeus.schedule.ScheduleControllerImpl;
import jeus.schedule.ScheduleListener;
import jeus.schedule.Scheduler;
import jeus.schedule.SchedulerExecutor;
import jeus.schedule.TaskHandler;
import jeus.util.message.JeusMessage_Scheduler;

public class JEUSScheduler
implements Scheduler {
    protected Integer scope;
    static final Integer NODE_SCOPE = new Integer(0);
    static final Integer CONTAINER_SCOPE = new Integer(1);
    private static final SchedulerExecutor[] executors = new SchedulerExecutor[2];
    private static final Object executorsLock = new Object();
    private static final int DEFAULT_POOL_MIN = 1;
    private static final int DEFAULT_POOL_MAX = 4;
    private static final long DEFAULT_POOL_KEEPALIVE = 3600000L;

    public JEUSScheduler() {
        this(CONTAINER_SCOPE);
    }

    JEUSScheduler(Integer scope) {
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(Integer scope, int pool_min, int pool_max, long pool_keepalive) {
        Object object = executorsLock;
        synchronized (object) {
            SchedulerExecutor executor = executors[scope];
            if (executor == null) {
                JEUSScheduler.executors[scope.intValue()] = executor = new SchedulerExecutor(pool_min, pool_max, pool_keepalive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stop(Integer scope) {
        Object object = executorsLock;
        synchronized (object) {
            SchedulerExecutor executor = executors[scope];
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SchedulerExecutor getExecutor(Integer scope) {
        Object object = executorsLock;
        synchronized (object) {
            SchedulerExecutor executor = executors[scope];
            if (executor == null) {
                JEUSScheduler.executors[scope.intValue()] = executor = new SchedulerExecutor(1, 4, 3600000L);
            }
            return executor;
        }
    }

    protected SchedulerExecutor getExecutor() {
        return JEUSScheduler.getExecutor(this.scope);
    }

    public void cancel() {
        this.getExecutor().cancel();
        if (Logger.logger.isLoggable(JeusMessage_Scheduler._21_LEVEL)) {
            Logger.logger.log(JeusMessage_Scheduler._21_LEVEL, JeusMessage_Scheduler._21);
        }
    }

    public synchronized ScheduleController registerSchedule(Schedule task, boolean isDaemon) throws RemoteException {
        this.validate((ScheduleListener)task);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, isDaemon, false);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerSchedule(String taskClassName, Hashtable parameters, boolean isDaemon) throws RemoteException {
        ScheduleListener task = this.instantiateScheduleListener(taskClassName);
        if (!(task instanceof Schedule)) {
            throw new JeusSchedulerException(JeusMessage_Scheduler._903, new String[]{taskClassName, Schedule.class.getName()});
        }
        if (task instanceof RemoteSchedule) {
            ((RemoteSchedule)task).initialize(parameters);
        }
        return this.registerSchedule((Schedule)task, isDaemon);
    }

    public synchronized ScheduleController registerSchedule(String taskClassName, Hashtable parameters, boolean isDaemon, boolean isThread) throws RemoteException {
        return this.registerSchedule(taskClassName, parameters, isDaemon);
    }

    public synchronized ScheduleController registerSchedule(ScheduleListener task, Date time, boolean isDaemon) throws RemoteException {
        this.validate(task, time, 1L, null, -1L);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, time, 0L, null, -1L, isDaemon, false);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerSchedule(ScheduleListener task, long delay, boolean isDaemon) throws RemoteException {
        this.validate(task, delay, 1L, null, -1L);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, delay, 0L, null, -1L, isDaemon, false);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerSchedule(ScheduleListener task, Date firstTime, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        this.validate(task, firstTime, period, endTime, maxcount);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, firstTime, period, endTime, maxcount, isDaemon, false);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerSchedule(ScheduleListener task, long delay, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        this.validate(task, delay, period, endTime, maxcount);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, delay, period, endTime, maxcount, isDaemon, false);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerSchedule(String taskClassName, Date firstTime, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        ScheduleListener task = this.instantiateScheduleListener(taskClassName);
        return this.registerSchedule(task, firstTime, period, endTime, maxcount, isDaemon);
    }

    public synchronized ScheduleController registerSchedule(String taskClassName, long delay, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        ScheduleListener task = this.instantiateScheduleListener(taskClassName);
        return this.registerSchedule(task, delay, period, endTime, maxcount, isDaemon);
    }

    public synchronized ScheduleController registerScheduleAtFixedRate(ScheduleListener task, Date firstTime, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        this.validate(task, firstTime, period, endTime, maxcount);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, firstTime, period, endTime, maxcount, isDaemon, true);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerScheduleAtFixedRate(ScheduleListener task, long delay, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        this.validate(task, delay, period, endTime, maxcount);
        TaskHandler handler = new TaskHandler(this.getExecutor(), task, delay, period, endTime, maxcount, isDaemon, true);
        return this.postRegister(handler);
    }

    public synchronized ScheduleController registerScheduleAtFixedRate(String taskClassName, Date firstTime, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        ScheduleListener task = this.instantiateScheduleListener(taskClassName);
        return this.registerScheduleAtFixedRate(task, firstTime, period, endTime, maxcount, isDaemon);
    }

    public synchronized ScheduleController registerScheduleAtFixedRate(String taskClassName, long delay, long period, Date endTime, long maxcount, boolean isDaemon) throws RemoteException {
        ScheduleListener task = this.instantiateScheduleListener(taskClassName);
        return this.registerScheduleAtFixedRate(task, delay, period, endTime, maxcount, isDaemon);
    }

    public Date getTimeAfterNow(Date time, long period) {
        Date firstTime;
        if (time == null) {
            throw new IllegalArgumentException("time is null");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period is non-positive");
        }
        Date now = new Date();
        long currentTime = now.getTime();
        long givenTime = time.getTime();
        if (givenTime < currentTime) {
            long diff = currentTime - givenTime;
            long nextTime = currentTime + (period - diff % period);
            firstTime = new Date(nextTime);
        } else {
            firstTime = new Date(givenTime);
        }
        return firstTime;
    }

    private ScheduleListener instantiateScheduleListener(String taskClassName) throws JeusSchedulerException {
        ScheduleListener task;
        try {
            Class<?> schedClass = Thread.currentThread().getContextClassLoader().loadClass(taskClassName);
            task = (ScheduleListener)schedClass.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new JeusSchedulerException("", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new JeusSchedulerException(JeusMessage_Scheduler._902, new String[]{taskClassName}, (Throwable)ex);
        }
        catch (ClassCastException ex) {
            throw new JeusSchedulerException(JeusMessage_Scheduler._903, new String[]{taskClassName, ScheduleListener.class.getName()}, (Throwable)ex);
        }
        catch (Throwable t) {
            throw new JeusSchedulerException(JeusMessage_Scheduler._900, new String[]{taskClassName}, t);
        }
        return task;
    }

    protected void validate(ScheduleListener task) throws IllegalStateException, IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
    }

    protected void validate(ScheduleListener task, Date firstTime, long period, Date endTime, long maxcount) throws IllegalStateException, IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (firstTime == null) {
            throw new IllegalArgumentException("firstTime cannot be null");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period cannot be non-positive");
        }
    }

    protected void validate(ScheduleListener task, long delay, long period, Date endTime, long maxcount) throws IllegalStateException, IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("delay cannot be negative");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period cannot be non-positive");
        }
    }

    protected ScheduleController postRegister(TaskHandler handler) throws RemoteException {
        ScheduleControllerImpl controller = new ScheduleControllerImpl(handler);
        ScheduleControllerImpl control = this.scope.equals(NODE_SCOPE) ? controller.export() : controller;
        handler.start();
        return control;
    }
}

