/*
 * Decompiled with CFR 0.152.
 */
package jeus.schedule;

import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jeus.schedule.Logger;
import jeus.schedule.Schedule;
import jeus.schedule.ScheduleListener;
import jeus.schedule.SchedulerExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Scheduler;

class TaskHandler {
    private static JeusLogger logger = Logger.logger;
    private SchedulerExecutor executor;
    private ScheduleListener task;
    private boolean instanceOfSchedule;
    private boolean fixedRate = false;
    private Date firstTime;
    private long period;
    private boolean periodic;
    private Date endTime;
    private long maxcount;
    private boolean daemon;
    private TimerTaskWrapper timerTask;
    private AtomicBoolean started = new AtomicBoolean();
    private AtomicBoolean finished = new AtomicBoolean();
    private AtomicInteger executedCount = new AtomicInteger(0);

    TaskHandler(SchedulerExecutor executor, Schedule task, boolean daemon, boolean isFixedRate) {
        this.instanceOfSchedule = true;
        long nextTime = task.nextTime(System.currentTimeMillis());
        this.init(executor, (ScheduleListener)task, new Date(nextTime), 1L, null, -1L, daemon, isFixedRate);
        if (nextTime <= 0L) {
            this.finished.set(true);
        }
    }

    TaskHandler(SchedulerExecutor executor, ScheduleListener task, Date firstTime, long period, Date endTime, long maxcount, boolean daemon, boolean isFixedRate) {
        this.init(executor, task, firstTime, period, endTime, maxcount, daemon, isFixedRate);
    }

    TaskHandler(SchedulerExecutor executor, ScheduleListener task, long delay, long period, Date endTime, long maxcount, boolean daemon, boolean isFixedRate) {
        long current = System.currentTimeMillis();
        Date firstTime = new Date(current + delay);
        this.init(executor, task, firstTime, period, endTime, maxcount, daemon, isFixedRate);
    }

    private void init(SchedulerExecutor executor, ScheduleListener task, Date firstTime, long period, Date endTime, long maxcount, boolean daemon, boolean isFixedRate) {
        assert (executor != null && task != null);
        this.executor = executor;
        this.task = task;
        this.firstTime = firstTime;
        this.period = period;
        this.endTime = endTime;
        this.maxcount = maxcount;
        this.daemon = daemon;
        if (period > 0L) {
            this.periodic = true;
        }
        this.fixedRate = isFixedRate;
    }

    private boolean isSetMaxCount() {
        return this.maxcount > 0L;
    }

    private boolean isFinished() {
        return this.finished.get();
    }

    void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Already started");
        }
        if (Logger.logger.isLoggable(JeusMessage_Scheduler._24_LEVEL)) {
            Logger.logger.log(JeusMessage_Scheduler._24_LEVEL, JeusMessage_Scheduler._24, (Object)this.task.toString());
        }
        long current = System.currentTimeMillis();
        if (this.maxcount == 0L) {
            this.finished.set(true);
        } else if (this.endTime != null && this.endTime.getTime() < current) {
            this.finished.set(true);
        } else if (this.firstTime != null && this.endTime != null && this.endTime.before(this.firstTime)) {
            this.finished.set(true);
        }
        if (this.finished.get()) {
            if (Logger.logger.isLoggable(JeusMessage_Scheduler._15_LEVEL)) {
                Logger.logger.log(JeusMessage_Scheduler._15_LEVEL, JeusMessage_Scheduler._15, (Object)this.task.toString());
            }
            return;
        }
        this.timerTask = new TimerTaskWrapper();
        if (this.fixedRate) {
            this.executor.scheduleAtFixedRate(this.timerTask, this.firstTime, this.period);
        } else {
            this.executor.schedule(this.timerTask, this.firstTime);
        }
    }

    private void cancelTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    void stop() {
        if (!this.finished.getAndSet(true)) {
            this.cancelTask();
            if (Logger.logger.isLoggable(JeusMessage_Scheduler._15_LEVEL)) {
                Logger.logger.log(JeusMessage_Scheduler._15_LEVEL, JeusMessage_Scheduler._15, (Object)this.task.toString());
            }
        }
    }

    long getPeriod() {
        return this.period;
    }

    Date getEndTime() {
        return this.endTime;
    }

    long getMaxCount() {
        return this.maxcount;
    }

    boolean isDaemon() {
        return this.daemon;
    }

    private class TimerTaskWrapper
    extends TimerTask {
        Worker worker = new Worker();
        AtomicLong executionStartTime = new AtomicLong();

        TimerTaskWrapper() {
        }

        public void run() {
            try {
                if (!this.beforeOnTime()) {
                    return;
                }
                this.executionStartTime.set(System.currentTimeMillis());
                TaskHandler.this.executor.execute(this.worker);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private boolean beforeOnTime() {
            int count;
            boolean shouldCancel = false;
            boolean shouldStopNow = false;
            if (TaskHandler.this.isSetMaxCount() && (long)(count = TaskHandler.this.executedCount.incrementAndGet()) >= TaskHandler.this.maxcount) {
                shouldCancel = true;
            }
            long currentTime = System.currentTimeMillis();
            if (TaskHandler.this.endTime != null && currentTime >= TaskHandler.this.endTime.getTime()) {
                shouldCancel = true;
                shouldStopNow = true;
            }
            if (shouldCancel) {
                TaskHandler.this.cancelTask();
            }
            if (shouldStopNow) {
                TaskHandler.this.stop();
            }
            return !shouldStopNow;
        }

        private void afterOnTime() {
            long currentTime = System.currentTimeMillis();
            boolean finished = false;
            if (TaskHandler.this.isSetMaxCount() && (long)TaskHandler.this.executedCount.get() >= TaskHandler.this.maxcount) {
                finished = true;
            } else if (TaskHandler.this.endTime != null && currentTime >= TaskHandler.this.endTime.getTime()) {
                finished = true;
            } else if (TaskHandler.this.instanceOfSchedule || TaskHandler.this.periodic && !TaskHandler.this.fixedRate) {
                long nextTime;
                if (TaskHandler.this.instanceOfSchedule) {
                    try {
                        nextTime = ((Schedule)TaskHandler.this.task).nextTime(currentTime);
                    }
                    catch (Throwable t) {
                        if (Logger.logger.isLoggable(JeusMessage_Scheduler._25_LEVEL)) {
                            Logger.logger.log(JeusMessage_Scheduler._25_LEVEL, JeusMessage_Scheduler._25, (Object)TaskHandler.this.task.toString(), t);
                        }
                        nextTime = 0L;
                    }
                } else {
                    nextTime = this.executionStartTime.get() + TaskHandler.this.period;
                }
                if (nextTime <= 0L) {
                    finished = true;
                } else {
                    try {
                        TaskHandler.this.timerTask = new TimerTaskWrapper();
                        TaskHandler.this.executor.schedule(TaskHandler.this.timerTask, new Date(nextTime));
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                }
            }
            if (finished) {
                TaskHandler.this.stop();
            }
        }

        private class Worker
        implements Runnable {
            private Worker() {
            }

            public void run() {
                block2: {
                    try {
                        TaskHandler.this.task.onTime();
                    }
                    catch (Throwable t) {
                        if (!Logger.logger.isLoggable(JeusMessage_Scheduler._6_LEVEL)) break block2;
                        Logger.logger.log(JeusMessage_Scheduler._6_LEVEL, JeusMessage_Scheduler._6, (Object)TaskHandler.this.task.toString(), t);
                    }
                }
                TimerTaskWrapper.this.afterOnTime();
            }
        }
    }
}

