/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.security.admin.SecurityAdminException;
import jeus.security.admin.command.AddCredentialCommand;
import jeus.security.admin.command.AddGroupCommand;
import jeus.security.admin.command.AddPrincipalCommand;
import jeus.security.admin.command.AddSubjectCommand;
import jeus.security.admin.command.AddUserToGroupCommand;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.AssignResourceCommand;
import jeus.security.admin.command.AssignRoleCommand;
import jeus.security.admin.command.AuthorizeResourceCommand;
import jeus.security.admin.command.AuthorizeRoleCommand;
import jeus.security.admin.command.CheckResourceCommand;
import jeus.security.admin.command.CheckRoleCommand;
import jeus.security.admin.command.ClearSubjectExpirationCommand;
import jeus.security.admin.command.Command;
import jeus.security.admin.command.ExcludeResourceCommand;
import jeus.security.admin.command.ExcludeRoleCommand;
import jeus.security.admin.command.GetCurrentDomainCommand;
import jeus.security.admin.command.GetCurrentSubjectCommand;
import jeus.security.admin.command.GetCurrentSubjectNameCommand;
import jeus.security.admin.command.GetGroupCommand;
import jeus.security.admin.command.GetGroupDescriptionCommand;
import jeus.security.admin.command.GetGroupListCommand;
import jeus.security.admin.command.GetGroupNamesCommand;
import jeus.security.admin.command.GetMembersFromGroupCommand;
import jeus.security.admin.command.GetPolicyCommand;
import jeus.security.admin.command.GetPolicyIdsCommand;
import jeus.security.admin.command.GetSubjectCommand;
import jeus.security.admin.command.GetSubjectNamesCommand;
import jeus.security.admin.command.GroupExistCommand;
import jeus.security.admin.command.IncludeResourceCommand;
import jeus.security.admin.command.IncludeRoleCommand;
import jeus.security.admin.command.IsMemberCommand;
import jeus.security.admin.command.LockSubjectCommand;
import jeus.security.admin.command.LoginCodeSubjectCommand;
import jeus.security.admin.command.LoginConfiguredCommand;
import jeus.security.admin.command.LoginPasswordCommand;
import jeus.security.admin.command.LogoutCommand;
import jeus.security.admin.command.RemoveCredentialCommand;
import jeus.security.admin.command.RemoveGroupCommand;
import jeus.security.admin.command.RemovePrincipalCommand;
import jeus.security.admin.command.RemoveSubjectCommand;
import jeus.security.admin.command.RemoveUserFromGroupCommand;
import jeus.security.admin.command.SavePolicyCommand;
import jeus.security.admin.command.SaveSubjectCommand;
import jeus.security.admin.command.SetGroupDescriptionCommand;
import jeus.security.admin.command.SetPasswordCommand;
import jeus.security.admin.command.SetSubjectDescriptionCommand;
import jeus.security.admin.command.SetSubjectExpirationCommand;
import jeus.security.admin.command.UnassignResourceCommand;
import jeus.security.admin.command.UnassignRoleCommand;
import jeus.security.admin.command.UncheckResourceCommand;
import jeus.security.admin.command.UncheckRoleCommand;
import jeus.security.admin.command.UnlockSubjectCommand;
import jeus.security.admin.command.UserExistCommand;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.Environment;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;
import jeus.security.util.StringSerializer;
import jeus.util.CUtility;
import jeus.util.console.ConsoleUtil;

public class SecurityAdminConsole
extends ConsoleUtil {
    private static final String PROMPT = "? ";
    private static final String NEWLINE = Constants.NEWLINE;
    private static final String HEADER = "Security Administration Console Version 1.0";
    private static final String COMMENT = "#";
    private static final String ECHO = "echo";
    private static final String EXIT = "exit";
    private static final String HELP = "help";
    private static final String ASSERT_TRUE = "asserttrue";
    private static final String ASSERT_FALSE = "assertfalse";
    private boolean done = false;
    private boolean silent = false;
    private boolean noprompt = false;
    private String[] startCommands = null;
    private InputStream in;
    private OutputStream out;
    private int[] tempBuffer = new int[1024];
    private Vector commands = new Vector();
    private Environment config;
    private int commandCounter = 0;

    public SecurityAdminConsole(String domain, boolean silent, boolean noprompt, String host, int port, String[] startCommands, InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.silent = silent;
        this.noprompt = noprompt;
        this.startCommands = startCommands;
        this.config = Environment.getSecurityManagementClientConfiguration();
        this.config.requiresSecureConnection = true;
        if (host != null) {
            this.config.hostNames = new String[]{host};
        }
        if (port >= 0) {
            this.config.baseSecurityPort = port;
        }
        if (domain != null) {
            this.config.defaultDomainName = domain;
            this.config.domains = new String[]{domain};
        } else {
            this.config.defaultDomainName = "SYSTEM_DOMAIN";
            this.config.domains = new String[]{"SYSTEM_DOMAIN"};
        }
        this.init();
    }

    private void init() {
        this.commands.add("Login & logout commands");
        this.commands.add(new LoginPasswordCommand());
        this.commands.add(new LoginConfiguredCommand());
        this.commands.add(new LoginCodeSubjectCommand());
        this.commands.add(new GetCurrentDomainCommand());
        this.commands.add(new GetCurrentSubjectNameCommand());
        this.commands.add(new GetCurrentSubjectCommand());
        this.commands.add(new LogoutCommand());
        this.commands.add("Subject management commands");
        this.commands.add(new AddSubjectCommand());
        this.commands.add(new RemoveSubjectCommand());
        this.commands.add(new GetSubjectNamesCommand());
        this.commands.add(new GetSubjectCommand());
        this.commands.add(new SetPasswordCommand());
        this.commands.add(new LockSubjectCommand());
        this.commands.add(new UnlockSubjectCommand());
        this.commands.add(new SetSubjectExpirationCommand());
        this.commands.add(new ClearSubjectExpirationCommand());
        this.commands.add(new AddPrincipalCommand());
        this.commands.add(new RemovePrincipalCommand());
        this.commands.add(new SetSubjectDescriptionCommand());
        this.commands.add(new AddCredentialCommand());
        this.commands.add(new RemoveCredentialCommand());
        this.commands.add(new SaveSubjectCommand());
        this.commands.add(new UserExistCommand());
        this.commands.add("Group management commands");
        this.commands.add(new AddGroupCommand());
        this.commands.add(new AddUserToGroupCommand());
        this.commands.add(new RemoveGroupCommand());
        this.commands.add(new RemoveUserFromGroupCommand());
        this.commands.add(new GetGroupCommand());
        this.commands.add(new GetGroupNamesCommand());
        this.commands.add(new GetGroupListCommand());
        this.commands.add(new GetGroupDescriptionCommand());
        this.commands.add(new SetGroupDescriptionCommand());
        this.commands.add(new GetMembersFromGroupCommand());
        this.commands.add(new IsMemberCommand());
        this.commands.add(new GroupExistCommand());
        this.commands.add("Policy management commands");
        this.commands.add(new GetPolicyCommand());
        this.commands.add(new GetPolicyIdsCommand());
        this.commands.add(new AssignRoleCommand());
        this.commands.add(new UnassignRoleCommand());
        this.commands.add(new ExcludeRoleCommand());
        this.commands.add(new IncludeRoleCommand());
        this.commands.add(new UncheckRoleCommand());
        this.commands.add(new CheckRoleCommand());
        this.commands.add(new AssignResourceCommand());
        this.commands.add(new UnassignResourceCommand());
        this.commands.add(new ExcludeResourceCommand());
        this.commands.add(new IncludeResourceCommand());
        this.commands.add(new UncheckResourceCommand());
        this.commands.add(new CheckResourceCommand());
        this.commands.add(new SavePolicyCommand());
        this.commands.add("Authorization commands");
        this.commands.add(new AuthorizeRoleCommand());
        this.commands.add(new AuthorizeResourceCommand());
    }

    private synchronized String getHelpString(String command) {
        StringBuffer buf = new StringBuffer();
        if (command != null) {
            buf.append(Constants.NEWLINE);
            boolean found = false;
            for (int i = 0; i < this.commands.size(); ++i) {
                Command cmd;
                Object o = this.commands.elementAt(i);
                if (!(o instanceof Command) || !(cmd = (Command)((Object)o)).getKeyword().equals(command)) continue;
                buf.append(cmd.toString());
                buf.append(Constants.NEWLINE);
                found = true;
                break;
            }
            if (!found) {
                buf.append("The command \"" + command + "\" does not exist");
                buf.append(Constants.NEWLINE);
            }
        } else {
            buf.append(Constants.NEWLINE);
            buf.append("Basic commands" + NEWLINE);
            buf.append(Constants.NEWLINE);
            buf.append("    help.................: print this help message" + NEWLINE);
            buf.append("    help <command name>..: print help about command" + NEWLINE);
            buf.append("    asserttrue <command>.: assert that command does not fail" + NEWLINE);
            buf.append("    assertfalse <command>: assert that command fails" + NEWLINE);
            buf.append("    echo <text>..........: print text" + NEWLINE);
            buf.append("    #....................: ignore line (comment)" + NEWLINE);
            buf.append("    exit.................: quit the tool" + NEWLINE);
            buf.append(Constants.NEWLINE);
            buf.append("Note: To include spaces in a string, surround string with \"\"" + NEWLINE);
            buf.append("Example: \"Hello World!\" will be treated as one string, not two" + NEWLINE);
            buf.append(Constants.NEWLINE);
            for (int i = 0; i < this.commands.size(); ++i) {
                Object o = this.commands.elementAt(i);
                if (o instanceof Command) {
                    Command cmd = (Command)((Object)o);
                    buf.append("    " + cmd.getKeyword());
                    buf.append(Constants.NEWLINE);
                    continue;
                }
                if (!(o instanceof String)) continue;
                buf.append(Constants.NEWLINE);
                buf.append((String)o);
                buf.append(Constants.NEWLINE);
                buf.append(Constants.NEWLINE);
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String adminUser, String adminPwd, String domain) {
        try {
            String result;
            String result2;
            String cmd;
            this.writeLine(HEADER + NEWLINE);
            SecurityInstaller.installSecurity(this.config);
            if (adminUser != null && adminPwd != null) {
                cmd = domain == null ? "login -username " + adminUser + " -password " + adminPwd : "login -username " + adminUser + " -password " + adminPwd + " -domain " + domain;
                result2 = this.processCommand(cmd).toString();
                if (result2 != null && result2.length() > 0) {
                    this.writeLine(result2);
                    this.writeLine(NEWLINE);
                }
            } else if (!this.noprompt) {
                while (!this.done) {
                    try {
                        cmd = this.loginAndReadLine();
                        result2 = this.processCommand(cmd).toString();
                        if (result2 == null || result2.length() <= 0) continue;
                        this.writeLine(result2);
                        this.writeLine(NEWLINE);
                    }
                    catch (SecurityAdminException e) {
                        this.writeLine(e.getMessage());
                        this.writeLine(NEWLINE);
                        if (e.getCmd() == null || (result = this.processCommand(e.getCmd()).toString()) == null || result.length() <= 0) continue;
                        this.writeLine(result);
                        this.writeLine(NEWLINE);
                    }
                    catch (Exception e) {
                        this.writeLine(e.getMessage());
                        this.writeLine(NEWLINE);
                    }
                }
            }
            if (this.startCommands != null) {
                for (int i = 0; i < this.startCommands.length; ++i) {
                    try {
                        result = this.processCommand(this.startCommands[i]).toString();
                        if (result == null || result.length() <= 0) continue;
                        this.writeLine(result);
                        this.writeLine(Constants.NEWLINE);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.writeLine(Constants.NEWLINE);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SecurityInstaller.uninstallSecurity();
        }
        this.writeLine("Executed " + this.commandCounter + " commands during this session.");
    }

    private String loginAndReadLine() {
        try {
            Subject subject = LoginService.getCurrentSubject();
            if (AnonymousSubject.isAnonymous(subject)) {
                this.writeLine("Login name>");
                String name = this.readLine();
                this.writeLine("Password>");
                String passwd = new String(CUtility.getInputBytes());
                this.writeLine(NEWLINE);
                if (name == null || passwd == null || name.length() == 0 || passwd.length() == 0) {
                    return EXIT;
                }
                return "login -username " + name + " -password " + passwd;
            }
            this.writeLine(PROMPT);
            return this.readLine();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String readLine() {
        try {
            int c = 0;
            int read = 0;
            while (c != 10) {
                c = this.in.read();
                if (c == 10) continue;
                this.tempBuffer[read++] = c;
            }
            StringBuffer buf = new StringBuffer("");
            for (int i = 0; i < read; ++i) {
                buf.append((char)this.tempBuffer[i]);
            }
            return buf.toString().trim();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    private void writeLine(String line) {
        this.writeLine(line, 0);
    }

    private void writeLine(String line, int indent) {
        if (this.silent || line == null || line.length() == 0) {
            return;
        }
        try {
            int i;
            for (i = 0; i < indent; ++i) {
                this.out.write(32);
            }
            for (i = 0; i < line.length(); ++i) {
                this.out.write(line.charAt(i));
            }
            this.out.flush();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private Object processCommand(String cmd) throws SecurityAdminException, Exception {
        if (cmd != null) {
            cmd = cmd.trim();
        }
        if (cmd == null || cmd.length() == 0 || cmd.startsWith(COMMENT)) {
            return "";
        }
        if (cmd.startsWith(ECHO)) {
            return cmd.substring(ECHO.length()).trim();
        }
        if (cmd.equals(EXIT)) {
            this.done = true;
            return "Bye!";
        }
        if (cmd.startsWith(ASSERT_TRUE)) {
            String cmdToAssert = cmd.substring(ASSERT_TRUE.length()).trim();
            try {
                this.processCommand(cmdToAssert);
                return "";
            }
            catch (Exception e) {
                return "**** Assert true failed ****" + Constants.NEWLINE + "Command: " + cmdToAssert + Constants.NEWLINE + "Exception: " + e.getMessage();
            }
        }
        if (cmd.startsWith(ASSERT_FALSE)) {
            String cmdToAssert = cmd.substring(ASSERT_FALSE.length()).trim();
            try {
                this.processCommand(cmdToAssert);
                return "**** Assert false failed ****" + Constants.NEWLINE + "Command: " + cmdToAssert;
            }
            catch (Exception e) {
                return "";
            }
        }
        if (cmd.startsWith(HELP)) {
            String[] cmds = SecurityAdminConsole.tokenize(cmd);
            if (cmds.length > 1) {
                return this.getHelpString(cmds[1]);
            }
            return this.getHelpString(null);
        }
        ++this.commandCounter;
        String[] cmds = SecurityAdminConsole.tokenize(cmd);
        if (cmds.length > 0) {
            String keyWord = cmds[0];
            Command theCommand = null;
            if (this.commands != null) {
                for (int i = 0; i < this.commands.size(); ++i) {
                    Command c;
                    Object o = this.commands.elementAt(i);
                    if (!(o instanceof Command) || !(c = (Command)((Object)o)).getKeyword().equals(keyWord)) continue;
                    theCommand = c;
                    break;
                }
            }
            if (theCommand == null) {
                throw new SecurityAdminException("Syntax error: not a valid keyword, type 'help'");
            }
            Hashtable args = new Hashtable();
            this.parseArguments(cmds, args, theCommand);
            return theCommand.run(args);
        }
        throw new SecurityAdminException("Syntax error: empty command");
    }

    static String[] tokenize(String cmds) {
        String cmd = cmds.trim();
        Vector<String> v = new Vector<String>();
        if (cmd != null) {
            int startMark = 0;
            boolean insideQuote = false;
            boolean fetching = false;
            for (int i = 0; i < cmd.length(); ++i) {
                if (insideQuote) {
                    if (cmd.charAt(i) == '\"') {
                        v.add(cmd.substring(startMark, i));
                        insideQuote = false;
                        continue;
                    }
                    if (cmd.length() - 1 != i) continue;
                    v.add(cmd.substring(startMark, i + 1));
                    insideQuote = false;
                    continue;
                }
                if (cmd.charAt(i) == '\"') {
                    insideQuote = true;
                    if (fetching) {
                        v.add(cmd.substring(startMark, i));
                        fetching = false;
                    }
                    startMark = i + 1;
                    continue;
                }
                if (Character.isWhitespace(cmd.charAt(i))) {
                    if (fetching) {
                        v.add(cmd.substring(startMark, i));
                        fetching = false;
                    }
                } else if (!fetching) {
                    fetching = true;
                    startMark = i;
                }
                if (cmd.length() - 1 != i || !fetching && Character.isWhitespace(cmd.charAt(i))) continue;
                v.add(cmd.substring(startMark, i + 1));
                fetching = false;
            }
        }
        return v.toArray(new String[0]);
    }

    private void parseArguments(String[] args, Map table, Command theCommand) throws Exception {
        if (args.length > 1) {
            String name = null;
            Vector<String> values = new Vector<String>();
            for (int i = 1; i < args.length; ++i) {
                try {
                    if (args[i].startsWith("-")) {
                        if (name != null) {
                            table.put(name, this.makeValue(values.toArray(new String[0]), theCommand.getArgument(name)));
                        }
                        name = args[i].substring(1);
                        values.clear();
                        continue;
                    }
                    values.add(args[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (name != null) {
                table.put(name, this.makeValue(values.toArray(new String[0]), theCommand.getArgument(name)));
            }
        }
        for (String argName : theCommand.getArgumentNames()) {
            Argument arg = theCommand.getArgument(argName);
            if (arg.isOptional() || table.keySet().contains(argName)) continue;
            SecurityAdminException exception = new SecurityAdminException("Syntax error: the non-optional argument \"" + argName + "\" is missing");
            exception.setCmd("help " + theCommand.getKeyword());
            throw exception;
        }
    }

    private Object makeValue(String[] values, Argument arg) {
        Class type = arg.getType();
        if (type.isArray()) {
            return StringSerializer.fromString(values, type);
        }
        if (values.length > 0) {
            return StringSerializer.fromString(values[0], type);
        }
        return StringSerializer.fromString((String)null, type);
    }

    public static void main(String[] args) {
        int commandsIndex = -1;
        boolean silent = false;
        boolean noprompt = false;
        int port = -1;
        String host = null;
        String commandFile = null;
        String domain = null;
        String adminUser = null;
        String adminPwd = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-port")) {
                    port = Integer.parseInt(args[i + 1]);
                    ++i;
                }
                if (args[i].equalsIgnoreCase("-host")) {
                    host = args[i + 1];
                    ++i;
                }
                if (args[i].equalsIgnoreCase("-adminuser")) {
                    adminUser = args[i + 1];
                    ++i;
                }
                if (args[i].equalsIgnoreCase("-adminpwd")) {
                    adminPwd = args[i + 1];
                    ++i;
                }
                if (args[i].equalsIgnoreCase("-silent")) {
                    silent = true;
                }
                if (args[i].equalsIgnoreCase("-noprompt")) {
                    noprompt = true;
                }
                if (args[i].equalsIgnoreCase("-domain")) {
                    domain = args[i + 1];
                    ++i;
                }
                if (args[i].equalsIgnoreCase("-commands")) {
                    commandsIndex = i + 1;
                }
                if (args[i].equalsIgnoreCase("-commandfile") && i < args.length - 1) {
                    commandFile = args[i + 1];
                    ++i;
                }
                if (args[i].equalsIgnoreCase("-version")) {
                    System.out.println(HEADER);
                    System.exit(0);
                }
                if (!args[i].equalsIgnoreCase("-help") && !args[i].equals("?")) continue;
                System.out.println("Usage: securityadmin [OPTIONS]");
                System.out.println("");
                System.out.println("OPTIONS:");
                System.out.println("   -help | ?                 Get some help");
                System.out.println("   -version                  Print tool version");
                System.out.println("   -domain <domainname>      The security domain to work with");
                System.out.println("   -host <hostname>          Remote hostname of security module");
                System.out.println("   -port <port>              Remote port of security module");
                System.out.println("   -silent                   Do not print anything");
                System.out.println("   -noprompt                 Do not display the prompt, just exit");
                System.out.println("   -commandfile <filename>   File with commands to run");
                System.out.println("   -commands <c1> <c2> <cN>  Commands to run");
                System.exit(0);
            }
        }
        Vector<String> scs = new Vector<String>();
        if (commandsIndex > 0) {
            for (int i = commandsIndex; i < args.length; ++i) {
                scs.add(args[i]);
            }
        }
        if (commandFile != null) {
            try {
                File file = new File(commandFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String command = null;
                do {
                    if ((command = reader.readLine()) == null) continue;
                    scs.add(command);
                } while (command != null);
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!noprompt) {
            silent = false;
        }
        SecurityAdminConsole sac = new SecurityAdminConsole(domain, silent, noprompt, host, port, scs.toArray(new String[0]), System.in, System.out);
        sac.run(adminUser, adminPwd, domain);
    }

    protected MBeanServerConnection initializeConnection() throws Exception {
        return null;
    }

    protected ObjectName getTargetObjectName() throws Exception {
        return null;
    }

    protected void registerCommands() {
        this.registerCommand(new LoginPasswordCommand());
        this.registerCommand(new LoginPasswordCommand());
        this.registerCommand(new LoginConfiguredCommand());
        this.registerCommand(new LoginCodeSubjectCommand());
        this.registerCommand(new GetCurrentDomainCommand());
        this.registerCommand(new GetCurrentSubjectNameCommand());
        this.registerCommand(new GetCurrentSubjectCommand());
        this.registerCommand(new LogoutCommand());
        this.registerCommand(new AddSubjectCommand());
        this.registerCommand(new RemoveSubjectCommand());
        this.registerCommand(new GetSubjectNamesCommand());
        this.registerCommand(new GetSubjectCommand());
        this.registerCommand(new SetPasswordCommand());
        this.registerCommand(new LockSubjectCommand());
        this.registerCommand(new UnlockSubjectCommand());
        this.registerCommand(new SetSubjectExpirationCommand());
        this.registerCommand(new ClearSubjectExpirationCommand());
        this.registerCommand(new AddPrincipalCommand());
        this.registerCommand(new RemovePrincipalCommand());
        this.registerCommand(new SetSubjectDescriptionCommand());
        this.registerCommand(new AddCredentialCommand());
        this.registerCommand(new RemoveCredentialCommand());
        this.registerCommand(new SaveSubjectCommand());
        this.registerCommand(new UserExistCommand());
        this.registerCommand(new AddGroupCommand());
        this.registerCommand(new AddUserToGroupCommand());
        this.registerCommand(new RemoveGroupCommand());
        this.registerCommand(new RemoveUserFromGroupCommand());
        this.registerCommand(new GetGroupCommand());
        this.registerCommand(new GetGroupNamesCommand());
        this.registerCommand(new GetGroupListCommand());
        this.registerCommand(new GetGroupDescriptionCommand());
        this.registerCommand(new SetGroupDescriptionCommand());
        this.registerCommand(new GetMembersFromGroupCommand());
        this.registerCommand(new IsMemberCommand());
        this.registerCommand(new GroupExistCommand());
        this.registerCommand(new GetPolicyCommand());
        this.registerCommand(new GetPolicyIdsCommand());
        this.registerCommand(new AssignRoleCommand());
        this.registerCommand(new UnassignRoleCommand());
        this.registerCommand(new ExcludeRoleCommand());
        this.registerCommand(new IncludeRoleCommand());
        this.registerCommand(new UncheckRoleCommand());
        this.registerCommand(new CheckRoleCommand());
        this.registerCommand(new AssignResourceCommand());
        this.registerCommand(new UnassignResourceCommand());
        this.registerCommand(new ExcludeResourceCommand());
        this.registerCommand(new IncludeResourceCommand());
        this.registerCommand(new UncheckResourceCommand());
        this.registerCommand(new CheckResourceCommand());
        this.registerCommand(new SavePolicyCommand());
        this.registerCommand(new AuthorizeRoleCommand());
        this.registerCommand(new AuthorizeResourceCommand());
    }

    protected void printCommandHelp() {
        System.out.println("Usage: securityadmin [OPTIONS]");
        System.out.println("");
        System.out.println("OPTIONS:");
        System.out.println("   -help | ?                 Get some help");
        System.out.println("   -version                  Print tool version");
        System.out.println("   -domain <domainname>      The security domain to work with");
        System.out.println("   -host <hostname>          Remote hostname of security module");
        System.out.println("   -port <port>              Remote port of security module");
        System.out.println("   -silent                   Do not print anything");
        System.out.println("   -noprompt                 Do not display the prompt, just exit");
        System.out.println("   -commandfile <filename>   File with commands to run");
        System.out.println("   -commands <c1> <c2> <cN>  Commands to run");
    }

    protected String getPrompt() {
        String[] containerNames = jeus.util.console.Command.getListProperty((String)"container.name");
        String prompt = "";
        if (containerNames == null) {
            return this.nodeName;
        }
        for (String container : containerNames) {
            prompt = prompt + container + ";";
        }
        return prompt.substring(0, prompt.lastIndexOf(";"));
    }

    protected String getWelcomeMessage() {
        return HEADER;
    }

    protected String[] processCmdArgs(String[] args) throws Exception {
        return new String[0];
    }

    public String getConsoleName() {
        return "security";
    }
}

