/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import java.util.StringTokenizer;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.CredentialFactory;
import jeus.security.base.PropertyHolder;
import jeus.security.base.Subject;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AddCredentialCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AddCredentialCommand() {
        super("addcredential", "Add a custom credential to a Subject");
        this.addArgument(new Argument("username", "The user name of the Subject for which to add the credential", String.class, false));
        this.addArgument(new Argument("classname", "The Java class name for a CredentialFactory", String.class, false));
        this.addArgument(new Argument("properties", "A property string for the CF. Format: name=value;name2=value2", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String username = (String)args.get("username");
        String classname = (String)args.get("classname");
        String properties = (String)args.get("properties");
        Subject sub = Subject.makeSubject(username);
        CredentialFactory cf = (CredentialFactory)Class.forName(classname).newInstance();
        AddCredentialCommand.addProperties(cf, properties);
        sub.getCredentialFactories().add(cf);
        AuthenticationRepositoryService.addSubject(sub);
        return "Added credential with credential factory \"" + classname + "\" to Subject \"" + username + "\"";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        String classname = this.getArgument("classname").getValue();
        String properties = this.getArgument("properties").getValue();
        Subject sub = Subject.makeSubject(username);
        CredentialFactory cf = (CredentialFactory)Class.forName(classname).newInstance();
        AddCredentialCommand.addProperties(cf, properties);
        sub.getCredentialFactories().add(cf);
        subjectMoMBean.addSubject(sub);
        out.println("Added credential with credential factory \"" + classname + "\" to Subject \"" + username + "\"");
    }

    public static void addProperties(PropertyHolder holder, String properties) {
        if (properties == null || holder == null) {
            return;
        }
        properties = properties.trim();
        StringTokenizer st = new StringTokenizer(properties, ";");
        while (st.hasMoreTokens()) {
            String prop = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(prop, "=");
            if (!st2.hasMoreTokens()) continue;
            String name = st2.nextToken().trim();
            String value = null;
            if (st2.hasMoreTokens()) {
                value = st2.nextToken().trim();
            }
            if (value != null) {
                holder.setProperty(name, value);
                continue;
            }
            holder.setProperty(name, "true");
        }
    }
}

