/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Subject;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AddPrincipalCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AddPrincipalCommand() {
        super("addprincipal", "Add a Principal to the Subject with the given user name");
        this.addArgument(new Argument("username", "Subject username", String.class, false));
        this.addArgument(new Argument("principal", "Principal name", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        AuthenticationRepositoryService.getSubject((String)args.get("username"));
        String username = (String)args.get("username");
        String principalName = (String)args.get("principal");
        Subject sub = Subject.makeSubject(username);
        sub.getPrincipals().add(new PrincipalImpl(principalName));
        AuthenticationRepositoryService.addSubject(sub);
        return "Added principal " + principalName + " to Subject " + username;
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        subjectMoMBean.getSubject(username);
        String principalName = this.getArgument("principal").getValue();
        Subject sub = Subject.makeSubject(username);
        sub.getPrincipals().add(new PrincipalImpl(principalName));
        subjectMoMBean.addSubject(sub);
        out.println("Added principal " + principalName + " to Subject " + username);
    }
}

