/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.acl.Group;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetGroupCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetGroupCommand() {
        super("getgroup", "Get Group from the current security domain");
        this.addArgument(new Argument("groupname", "Group name", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String groupname = (String)args.get("groupname");
        return AuthenticationRepositoryService.getGroup(groupname);
    }

    public String getKeyword() {
        return "getgroup";
    }

    public String getDescription() {
        return "Get Group from the current security domain";
    }

    public Class getReturnType() {
        return Group.class;
    }

    public void run(PrintStream out) throws Throwable {
        String groupname = this.getArgument("groupname").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        out.println(subjectMoMBean.getGroup(groupname));
    }
}

