/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetGroupDescriptionCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetGroupDescriptionCommand() {
        super("getgroupdescription", "Get the description for the Group with the given group name");
        this.addArgument(new Argument("groupname", "Group name", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String groupname = (String)args.get("groupname");
        GroupPrincipalImpl group = (GroupPrincipalImpl)AuthenticationRepositoryService.getGroup(groupname);
        return group.getDescription();
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String groupname = this.getArgument("groupname").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)subjectMoMBean.getGroup(groupname);
        out.println(group.getDescription());
    }
}

