/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Policy;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetPolicyCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetPolicyCommand() {
        super("getpolicy", "Get a Policy containing the given context id from the current security domain");
        this.addArgument(new Argument("contextid", "Context id of Policy to be gotten (default: \"default\")", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String contextid = (String)args.get("contextid");
        if (contextid == null) {
            contextid = "default";
        }
        return AuthorizationRepositoryService.getPolicy(contextid);
    }

    public Class getReturnType() {
        return Policy.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname;
        PolicyMoMBean policyMoMBean;
        String contextid = this.getArgument("contextid").getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname = this.domain.getValue())) == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        out.println(policyMoMBean.getPolicy(contextid));
    }
}

