/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Command;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.util.Constants;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetPolicyIdsCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetPolicyIdsCommand() {
        super("getpolicyids", "Get all Policy context ids in the current Domain");
        this.registerArgument((Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        Iterator names = AuthorizationRepositoryService.getPolicyIds().iterator();
        int i = 1;
        StringBuffer result = new StringBuffer();
        while (names.hasNext()) {
            result.append(i + ". ");
            result.append((String)names.next());
            result.append(Constants.NEWLINE);
            ++i;
        }
        result.append("Got " + (i - 1) + " Policy context ids");
        return result.toString();
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname = this.domain.getValue();
        PolicyMoMBean policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname);
        if (policyMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        Iterator names = policyMoMBean.getPolicyIds().iterator();
        int i = 1;
        StringBuffer result = new StringBuffer();
        while (names.hasNext()) {
            result.append(i + ". ");
            result.append((String)names.next());
            result.append(Constants.NEWLINE);
            ++i;
        }
        result.append("Got " + (i - 1) + " Policy context ids");
        out.println(result.toString());
    }
}

