/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Policy;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class IncludeRoleCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public IncludeRoleCommand() {
        super("includerole", "Include a role (undo effect of excluderole)");
        this.addArgument(new Argument("role", "The name of role to be included", String.class, false));
        this.addArgument(new Argument("actions", "The actions of the role", String.class, true));
        this.addArgument(new Argument("contextid", "Policy context id for role", String.class, true));
        this.addArgument(new Argument("classname", "The classname of the Permission", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String classname;
        String role = (String)args.get("role");
        String contextid = (String)args.get("contextid");
        String actions = (String)args.get("actions");
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = (String)args.get("classname")) == null) {
            classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)role, (String)actions);
        Policy policy = new Policy();
        policy.getRolePolicy().addPermission(p, null, true, false);
        policy.getResourcePolicy(contextid, true);
        AuthorizationRepositoryService.removePolicy(policy);
        return "Included role \"" + role + "\"";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String classname;
        String role = this.getArgument("role").getValue();
        String contextid = this.getArgument("contextid").getValue();
        String actions = this.getArgument("actions").getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = this.getArgument("classname").getValue()) == null) {
            classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)role, (String)actions);
        Policy policy = new Policy();
        policy.getRolePolicy().addPermission(p, null, true, false);
        policy.getResourcePolicy(contextid, true);
        String domainname = this.domain.getValue();
        PolicyMoMBean policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname);
        if (policyMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        policyMoMBean.removePolicy(policy);
        out.println("Included role \"" + role + "\"");
    }
}

