/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.console.ArgumentedOption;

public class LoginPasswordCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public LoginPasswordCommand() {
        super("login", "Log in the specified user using a basic password-based mechanism");
        this.addArgument(new Argument("username", "the username", String.class, false));
        this.addArgument(new Argument("password", "the password", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String username = (String)args.get("username");
        String password = (String)args.get("password");
        String domainname = this.domain.getValue();
        Subject sub = Subject.makeSubject(domainname, username, password);
        LoginService.login(sub);
        return "User " + username + " successfully logged in";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String password = this.getArgument("password").getValue();
        String domainname = this.domain.getValue();
        Subject sub = Subject.makeSubject(domainname, username, password);
        LoginService.login(sub);
        out.println("User " + username + " successfully logged in");
    }
}

