/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Subject;
import jeus.security.resource.PasswordFactory;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.util.SetUtil;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class SetPasswordCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public SetPasswordCommand() {
        super("setpassword", "Set the password for the Subject with the given user name");
        this.addArgument(new Argument("username", "Subject username", String.class, false));
        this.addArgument(new Argument("password", "Subject password", String.class, false));
    }

    public Object run(Map args) throws Exception {
        Subject sub = Subject.makeSubject((String)args.get("username"), (String)args.get("password"), true);
        Subject sub2 = AuthenticationRepositoryService.getSubject((String)args.get("username"));
        Set s = SetUtil.getMembers(PasswordFactory.class, sub2.getCredentialFactories());
        Subject sub3 = Subject.makeSubject((String)args.get("username"));
        sub3.getCredentialFactories().addAll(s);
        AuthenticationRepositoryService.addSubject(sub);
        AuthenticationRepositoryService.removeSubject(sub3);
        return "Password set for " + (String)args.get("username");
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        Subject sub = Subject.makeSubject(username, this.getArgument("password").getValue(), true);
        Subject sub2 = subjectMoMBean.getSubject(username);
        Set s = SetUtil.getMembers(PasswordFactory.class, sub2.getCredentialFactories());
        Subject sub3 = Subject.makeSubject(username);
        sub3.getCredentialFactories().addAll(s);
        subjectMoMBean.addSubject(sub);
        subjectMoMBean.removeSubject(sub3);
        out.println("Password set for " + username);
    }
}

