/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Subject;
import jeus.security.resource.ExpiryTimeFactory;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class SetSubjectExpirationCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public SetSubjectExpirationCommand() {
        super("setsubjectexpiration", "Set the expiration time for Subject with the given user name");
        this.addArgument(new Argument("username", "Subject username", String.class, false));
        this.addArgument(new Argument("expirytime", "The expiry time with format \"YYYY MM DD HH MM\"", String.class, false));
    }

    public Object run(Map args) throws Exception {
        AuthenticationRepositoryService.getSubject((String)args.get("username"));
        Subject sub = Subject.makeSubject((String)args.get("username"));
        ExpiryTimeFactory etf = new ExpiryTimeFactory();
        etf.setProperty("expires", (String)args.get("expirytime"));
        sub.getCredentialFactories().add(etf);
        AuthenticationRepositoryService.addSubject(sub);
        return "Expiration time set for Subject " + (String)args.get("username");
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        subjectMoMBean.getSubject(username);
        Subject sub = Subject.makeSubject(username);
        ExpiryTimeFactory etf = new ExpiryTimeFactory();
        etf.setProperty("expires", this.getArgument("expirytime").getValue());
        sub.getCredentialFactories().add(etf);
        subjectMoMBean.addSubject(sub);
        out.println("Expiration time set for Subject " + username);
    }
}

