/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class UserExistCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public UserExistCommand() {
        super("userexist", "Existed User from the current security domain");
        this.addArgument(new Argument("username", "User name", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String username = (String)args.get("username");
        if (AuthenticationRepositoryService.userExist(username)) {
            return "The User(" + username + ") exist in the current security domain";
        }
        return "The User(" + username + ") doesn't exist in the current security domain";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        if (subjectMoMBean.userExist(username)) {
            out.println("The User(" + username + ") exist in the current security domain");
        } else {
            out.println("The User(" + username + ") doesn't exist in the current security domain");
        }
    }
}

