/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.security.Principal;
import jeus.security.base.Domain;
import jeus.security.base.Subject;
import jeus.security.resource.PrincipalImpl;

public final class AnonymousSubject
extends Subject {
    public static String ANONYMOUS_PRINCIPAL_NAME = "anonymous";
    public static final PrincipalImpl ANONYMOUS_PRINCIPAL = new PrincipalImpl(ANONYMOUS_PRINCIPAL_NAME);
    public static final Subject singleton = new AnonymousSubject(Domain.DEFAULT_APPLICATION_DOMAIN_NAME);

    public AnonymousSubject(String domainName) {
        super(domainName, ANONYMOUS_PRINCIPAL);
    }

    public AnonymousSubject() {
        super(null, new PrincipalImpl(ANONYMOUS_PRINCIPAL_NAME));
    }

    public static boolean isAnonymous(Subject subj) {
        try {
            if (subj instanceof AnonymousSubject) {
                return true;
            }
            Principal p = subj.getPrincipal();
            return p != null && p.getName().equals(ANONYMOUS_PRINCIPAL_NAME);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] serialize() {
        return new byte[0];
    }

    public static Subject deserialize(byte[] bytes) {
        return Domain.getAnonymousSubject();
    }
}

