/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.web;

import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import jeus.security.base.PermissionMap;
import jeus.security.resource.PrincipalImpl;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.EmptyType;
import jeus.xml.binding.jeusDD.RoleMappingType;
import jeus.xml.binding.jeusDD.RolePermissionType;

public class XMLJEUSWebDDConverter
extends XMLConverter {
    public XMLJEUSWebDDConverter() throws Exception {
        super("jeus.xml.binding.jeusDD");
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        ContextType context = (ContextType)contentTree;
        RoleMappingType roles = context.getRoleMapping();
        if (roles == null) {
            return new PermissionMap();
        }
        return this.getRolePermissionsPC(roles);
    }

    private PermissionMap getRolePermissionsPC(RoleMappingType contentTree) throws Exception {
        Iterator rps = contentTree.getRolePermission().iterator();
        PermissionMap pc = new PermissionMap();
        while (rps.hasNext()) {
            RolePermissionType rpt = (RolePermissionType)rps.next();
            String className = rpt.getClassname() == null ? Constants.DEFAULT_PR_PERMISSION_CLASSNAME : rpt.getClassname();
            String role = rpt.getRole();
            String actions = rpt.getActions();
            EmptyType ex = rpt.getExcluded();
            EmptyType un = rpt.getUnchecked();
            Permission p = PermissionMaker.makePermission((String)className, (String)role, (String)actions);
            boolean excluded = false;
            boolean unchecked = false;
            if (ex != null) {
                excluded = true;
            }
            if (un != null) {
                unchecked = true;
            }
            List princeList = rpt.getPrincipal();
            Object[] ps = new Object[princeList.size()];
            Iterator principals = princeList.iterator();
            int i = 0;
            while (principals.hasNext()) {
                String pp = (String)principals.next();
                ps[i++] = new PrincipalImpl(pp);
            }
            pc.addPermission(p, ps, excluded, unchecked);
        }
        return pc;
    }

    protected Object toXMLTree(Object object, Object tree) {
        return null;
    }
}

