/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atn;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.atnrep.XMLCertUserMapConverter;
import jeus.security.spi.IdentityAssertionService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.NameAndPathUtil;
import jeus.security.util.X509Util;
import sun.security.x509.X500Name;

public class DefaultIdentityAssertionService
extends IdentityAssertionService {
    private File theFile;
    private XMLCertUserMapConverter conv;
    private String certAttrType;
    private String delimiter;
    private String certAttrKey;
    private Map certUserMap;
    boolean existCertMap = false;

    protected void doCreate() throws ServiceException, SecurityException {
        String filename = this.getProperty("filename");
        if (filename == null) {
            String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
            filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "cert-user-map.xml";
        }
        this.theFile = new File(filename);
        if (this.theFile.exists()) {
            this.certUserMap = new HashMap();
            try {
                this.conv = new XMLCertUserMapConverter(this.certUserMap);
                this.refreshRead();
                this.existCertMap = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.certAttrType = this.getProperty("cert-attr-type");
        this.certAttrKey = this.getProperty("attr-key");
        this.delimiter = this.getProperty("attr-value-delimiter");
    }

    private void refreshRead() throws ServiceException {
        try {
            this.conv.unmarshal(this.theFile);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading cert-user-map.xml XML file: exception occured", e);
        }
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected Object doIdentity(Object token) throws ServiceException, SecurityException {
        String key = this.getUserNameInCertificate((X509Certificate)token);
        String username = null;
        if (key != null && this.existCertMap) {
            username = (String)this.certUserMap.get(key);
        }
        if (username == null) {
            username = key;
        }
        return username;
    }

    private String getUserNameInCertificate(X509Certificate token) throws SecurityException {
        if (this.certAttrType == null) {
            return this.getCommonNameFromX500Name(token);
        }
        if (this.certAttrType.equals("SKI")) {
            try {
                return new String(X509Util.getSKIBytesFromCert(token));
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        if (this.certAttrType.equals("issuer_serial")) {
            return X509Util.getIssuerDNAndSerialNo(token);
        }
        if (this.certAttrType.equals("alias")) {
            return X509Util.getAliasInTrustStore(this.getDomain().getTrustStore(), token);
        }
        if (this.certAttrType.equals("SubjectDN")) {
            return X509Util.getSubjectDNFromCertificate(token, this.certAttrKey, this.delimiter);
        }
        return this.getCommonNameFromX500Name(token);
    }

    private String getCommonNameFromX500Name(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        Principal principal = x509Certificate.getSubjectDN();
        if (principal instanceof X500Name) {
            X500Name x500Name = (X500Name)principal;
            try {
                return x500Name.getCommonName();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

