/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jeus.security.base.ClientService;
import jeus.security.base.Domain;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class ClientAuthenticationRepositoryService
extends AuthenticationRepositoryService
implements ClientService {
    private static final int OP_SUBJECT_TYPE = 1;
    private static final int OP_GROUP_TYPE = 2;
    private static boolean enableClientCache = true;
    Hashtable subjectCache = new Hashtable();
    Hashtable groupCache = new Hashtable();

    public Object getMBean() {
        return null;
    }

    protected MBeanInfo getMBeanInfo() {
        return null;
    }

    protected void doCreate() {
        enableClientCache = SecurityInstaller.getEnvironment().isEnableClientAtnCache();
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public void removeCache(String node) {
        this.subjectCache.remove(node);
        this.groupCache.remove(node);
    }

    protected Subject doGetSubject(String name) throws ServiceException, SecurityException {
        Subject sub;
        if (enableClientCache && (sub = (Subject)this.getCache(1).get(name)) != null) {
            return sub;
        }
        sub = (Subject)NetworkService.sendMessage(new NetworkMessage(2, LoginService.getCurrentSubject(), new Serializable[]{name}), false);
        this.getCache(1).put(name, sub);
        return sub;
    }

    protected Subject doGetSubject(Subject subj) throws ServiceException, SecurityException {
        Subject sub;
        String name = subj.getPrincipal().getName();
        if (enableClientCache && (sub = (Subject)this.getCache(1).get(name)) != null) {
            return sub;
        }
        sub = (Subject)NetworkService.sendMessage(new NetworkMessage(2, subj, new Serializable[]{name}), false);
        this.getCache(1).put(name, sub);
        return sub;
    }

    protected Set doGetSubjectNames() throws ServiceException, SecurityException {
        if (enableClientCache) {
            return this.getCache(1).keySet();
        }
        return (Set)NetworkService.sendMessage(new NetworkMessage(3, LoginService.getCurrentSubject(), null), false);
    }

    protected Subject[] doGetSubjectsAsArray() throws ServiceException, SecurityException {
        return this.getCache(1).values().toArray(new Subject[0]);
    }

    protected void doAddSubject(Subject subject) throws ServiceException, SecurityException {
        NetworkService.sendMessage(new NetworkMessage(4, LoginService.getCurrentSubject(), new Serializable[]{subject}), false);
        this.getCache(1).put(subject.getPrincipal().getName(), subject);
    }

    protected void doRemoveSubject(Subject subject) throws ServiceException, SecurityException {
        block4: {
            NetworkService.sendMessage(new NetworkMessage(5, LoginService.getCurrentSubject(), new Serializable[]{subject}), false);
            this.getCache(1).remove(subject.getPrincipal().getName());
            try {
                ClientService clientService;
                String node;
                Service service = Domain.SHARED_DOMAIN.getOneService(AuthenticationService.class);
                if (service instanceof ClientService) {
                    node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
                if ((service = Domain.SHARED_DOMAIN.getOneService(LoginService.class)) instanceof ClientService) {
                    node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._14_LEVEL)) break block4;
                LoggerUtil.logger.log(JeusMessage_Security._14_LEVEL, JeusMessage_Security._14, (Throwable)e);
            }
        }
    }

    public void doAddSubject(Subject subject, boolean localAdd) throws ServiceException, SecurityException {
        NetworkService.sendMessage(new NetworkMessage(4, LoginService.getCurrentSubject(), new Serializable[]{subject}), false);
        this.getCache(1).put(subject.getPrincipal().getName(), subject);
    }

    public void doRemoveSubject(Subject subject, boolean localRemove) throws ServiceException, SecurityException {
        block4: {
            NetworkService.sendMessage(new NetworkMessage(5, LoginService.getCurrentSubject(), new Serializable[]{subject}), false);
            this.getCache(1).remove(subject.getPrincipal().getName());
            try {
                ClientService clientService;
                String node;
                Service service = Domain.SHARED_DOMAIN.getOneService(AuthenticationService.class);
                if (service instanceof ClientService) {
                    node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
                if ((service = Domain.SHARED_DOMAIN.getOneService(LoginService.class)) instanceof ClientService) {
                    node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._14_LEVEL)) break block4;
                LoggerUtil.logger.log(JeusMessage_Security._14_LEVEL, JeusMessage_Security._14, (Throwable)e);
            }
        }
    }

    protected void doRemoveSubject(String name) throws ServiceException, SecurityException {
        block4: {
            NetworkService.sendMessage(new NetworkMessage(6, LoginService.getCurrentSubject(), new Serializable[]{name}), false);
            this.getCache(1).remove(name);
            try {
                ClientService clientService;
                String node;
                Service service = Domain.SHARED_DOMAIN.getOneService(AuthenticationService.class);
                if (service instanceof ClientService) {
                    node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
                if ((service = Domain.SHARED_DOMAIN.getOneService(LoginService.class)) instanceof ClientService) {
                    node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._14_LEVEL)) break block4;
                LoggerUtil.logger.log(JeusMessage_Security._14_LEVEL, JeusMessage_Security._14, (Throwable)e);
            }
        }
    }

    public void doSave() throws ServiceException, SecurityException {
        NetworkService.sendMessage(new NetworkMessage(16, LoginService.getCurrentSubject(), null), false);
    }

    public boolean doUserExists(String userName) throws ServiceException, SecurityException {
        Subject sub;
        if (enableClientCache && (sub = (Subject)this.getCache(1).get(userName)) != null) {
            return true;
        }
        sub = (Subject)NetworkService.sendMessage(new NetworkMessage(2, LoginService.getCurrentSubject(), new Serializable[]{userName}), false);
        this.getCache(1).put(userName, sub);
        return true;
    }

    public boolean doGroupExist(String groupName) throws ServiceException, SecurityException {
        GroupPrincipalImpl group;
        if (enableClientCache && (group = (GroupPrincipalImpl)this.getCache(2).get(groupName)) != null) {
            return true;
        }
        group = (GroupPrincipalImpl)NetworkService.sendMessage(new NetworkMessage(18, LoginService.getCurrentSubject(), new Serializable[]{groupName}), false);
        this.getCache(2).put(groupName, group);
        return true;
    }

    public void doAddGroup(Group group) throws SecurityException, ServiceException {
        NetworkService.sendMessage(new NetworkMessage(21, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{(GroupPrincipalImpl)group}), false);
        this.getCache(2).put(group.getName(), group);
    }

    public void doAddUserToGroup(String groupName, Principal principal) throws SecurityException, ServiceException {
        GroupPrincipalImpl group = (GroupPrincipalImpl)this.getCache(2).get(groupName);
        if (group == null) {
            group = (GroupPrincipalImpl)NetworkService.sendMessage(new NetworkMessage(18, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName}), false);
        }
        NetworkService.sendMessage(new NetworkMessage(22, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName, (PrincipalImpl)principal}), false);
        group.addMember(principal);
        this.getCache(2).put(group.getName(), group);
    }

    public Group doGetGroup(String groupName) throws ServiceException, SecurityException {
        GroupPrincipalImpl group;
        if (enableClientCache && (group = (GroupPrincipalImpl)this.getCache(2).get(groupName)) != null) {
            return group;
        }
        group = (GroupPrincipalImpl)NetworkService.sendMessage(new NetworkMessage(18, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName}), false);
        this.getCache(2).put(group.getName(), group);
        return group;
    }

    public Set doGetGroupNames() throws ServiceException, SecurityException {
        if (enableClientCache) {
            return this.getCache(2).keySet();
        }
        return (Set)NetworkService.sendMessage(new NetworkMessage(20, LoginService.getCurrentSubject(), null), false);
    }

    public Group[] doGetGroupList() throws SecurityException, ServiceException {
        if (enableClientCache) {
            Hashtable groups = this.getCache(2);
            return groups.values().toArray(new GroupPrincipalImpl[groups.size()]);
        }
        return (GroupPrincipalImpl[])NetworkService.sendMessage(new NetworkMessage(19, LoginService.getCurrentSubject(), null), false);
    }

    public boolean doIsMember(String groupName, Principal principal) throws ServiceException, SecurityException {
        GroupPrincipalImpl group;
        if (enableClientCache && (group = (GroupPrincipalImpl)this.getCache(2).get(groupName)) != null) {
            return group.isMember(principal);
        }
        group = (GroupPrincipalImpl)NetworkService.sendMessage(new NetworkMessage(18, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName}), false);
        this.getCache(2).put(group.getName(), group);
        return group.isMember(principal);
    }

    public Enumeration doGetMembersFromGroup(String groupName) throws ServiceException, SecurityException {
        GroupPrincipalImpl group;
        if (enableClientCache && (group = (GroupPrincipalImpl)this.getCache(2).get(groupName)) != null) {
            return group.members();
        }
        group = (GroupPrincipalImpl)NetworkService.sendMessage(new NetworkMessage(18, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName}), false);
        this.getCache(2).put(group.getName(), group);
        return group.members();
    }

    public Object readSubjectsInRepository() throws ServiceException {
        return null;
    }

    public void writeSubjectsToRepository(Object subjects) throws ServiceException {
    }

    public void doRemoveGroup(String groupName) throws SecurityException, ServiceException {
        GroupPrincipalImpl group = (GroupPrincipalImpl)this.getCache(2).get(groupName);
        if (group != null) {
            this.getCache(2).remove(groupName);
        }
        NetworkService.sendMessage(new NetworkMessage(23, LoginService.getCurrentSubject(), new Serializable[]{groupName}), false);
    }

    public void doRemoveUserFromGroup(String groupName, Principal principal) throws SecurityException, ServiceException {
        GroupPrincipalImpl group = (GroupPrincipalImpl)this.getCache(2).get(groupName);
        if (group == null) {
            group = (GroupPrincipalImpl)NetworkService.sendMessage(new NetworkMessage(18, LoginService.getCurrentSubject(), new Serializable[]{groupName}), false);
        }
        NetworkService.sendMessage(new NetworkMessage(24, LoginService.getCurrentSubject(), new Serializable[]{groupName, (PrincipalImpl)principal}), false);
        group.removeMember(principal);
        this.getCache(2).put(groupName, group);
    }

    private Hashtable getCache(int type) {
        String node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
        return this.getCache(node, type);
    }

    private Hashtable getCache(String node, int type) {
        Hashtable objTable = type == 1 ? this.subjectCache : this.groupCache;
        Object hash = objTable.get(node);
        if (hash == null) {
            hash = new Hashtable();
            objTable.put(node, hash);
            return (Hashtable)hash;
        }
        return (Hashtable)hash;
    }

    public void refreshRepositryService() throws ServiceException {
    }
}

