/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.SubjectMo;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.JeusDistributedMemoryAuthenticationRepositoryService;
import jeus.security.resource.DBSubjectQuery;
import jeus.security.spi.GroupNotExistsException;
import jeus.security.spi.SubjectNotExistsException;
import jeus.security.util.DBDriverConverter;
import jeus.security.util.DataSourceConverter;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.SQLQueryConstants;

public class DBRealmAuthenticationRepositoryService
extends JeusDistributedMemoryAuthenticationRepositoryService {
    protected DBSubjectQuery conv;
    protected SubjectMo subjectMo;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        String dsExportName = this.getProperty("export-name");
        try {
            if (dsExportName == null) {
                String vendor = this.getProperty("vendor");
                if (vendor == null || vendor.equals("")) {
                    throw new Exception("vendor is not set");
                }
                String driver = this.getProperty("driver");
                if (driver == null || driver.equals("")) {
                    throw new Exception("driver is not set");
                }
                String url = this.getProperty("url");
                if (url == null || url.equals("")) {
                    throw new Exception("url is not set");
                }
                String username = this.getProperty("username");
                if (username == null || username.equals("")) {
                    throw new Exception("username is not set");
                }
                String password = this.getProperty("password");
                if (password == null) {
                    throw new Exception("password is not set");
                }
                this.conv = new DBDriverConverter(this.getDomain().getName(), vendor, driver, url, username, EncryptionUtil.decryptPassword(password));
            } else {
                this.conv = new DataSourceConverter(this.getDomain().getName(), dsExportName);
            }
            SQLQueryConstants queryConstants = new SQLQueryConstants();
            queryConstants.initSubjectSQLQuery();
            Enumeration<?> enum1 = this.propertyNames();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                if (!name.startsWith("SQLQuery:")) continue;
                String key = name.substring(9);
                String value = this.getProperty(key);
                queryConstants.setSQLQuery(key, value);
            }
            this.conv.setProp(queryConstants.getSQLQueryProp());
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating DBRealmAuthenticationRepositoryService: exception occured", e);
        }
    }

    protected void doDestroy() {
        this.conv = null;
        super.doDestroy();
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.subjectMo = (SubjectMo)SubjectMo.createMBean("Subject", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Subject doGetSubject(String name) throws ServiceException, SecurityException {
        Subject subject;
        try {
            subject = super.doGetSubject(name);
        }
        catch (SubjectNotExistsException e) {
            subject = this.conv.queryGetSubject(name);
        }
        if (subject == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + name + " does not exist, domain is " + this.getDomain().getName());
        }
        return subject;
    }

    protected Set doGetSubjectNames() throws ServiceException, SecurityException {
        return this.conv.queryGetSubjectNames();
    }

    protected void doAddSubject(Subject subject) throws ServiceException, SecurityException {
        super.doAddSubject(subject);
        this.conv.queryAddSubject(super.doGetSubject(subject.getPrincipal().getName()));
    }

    protected void doRemoveSubject(Subject subject) throws ServiceException, SecurityException {
        try {
            super.doRemoveSubject(subject);
        }
        catch (SubjectNotExistsException e) {
            this.conv.queryRemoveSubject(subject);
            return;
        }
        this.conv.queryRemoveSubject(subject);
    }

    public void doAddSubject(Subject subject, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddSubject(subject, localAdd);
        if (!localAdd) {
            this.conv.queryAddSubject(subject);
        }
    }

    public void doRemoveSubject(Subject subject, boolean localRemove) throws ServiceException, SecurityException {
        try {
            super.doRemoveSubject(subject, localRemove);
        }
        catch (SubjectNotExistsException e) {
            this.conv.queryRemoveSubject(subject);
            return;
        }
        if (!localRemove) {
            this.conv.queryRemoveSubject(subject);
        }
    }

    protected void doRemoveSubject(String name) throws ServiceException, SecurityException {
        try {
            super.doRemoveSubject(name);
        }
        catch (SubjectNotExistsException e) {
            this.conv.queryRemoveSubject(name);
            return;
        }
        this.conv.queryRemoveSubject(name);
    }

    public void doSave() throws ServiceException, SecurityException {
        Subject[] subjects = super.doGetSubjectsAsArray();
        this.conv.querySubjectSave(subjects);
    }

    public boolean doUserExists(String userName) {
        return this.conv.queryUserExists(userName);
    }

    public boolean doGroupExist(String groupName) {
        return this.conv.queryGroupExist(groupName);
    }

    public void doAddGroup(Group group) throws ServiceException, SecurityException {
        super.doAddGroup(group);
        this.conv.queryAddGroup(group);
    }

    public void doAddUserToGroup(String groupName, Principal principal) throws ServiceException, SecurityException {
        try {
            super.doAddUserToGroup(groupName, principal);
        }
        catch (SubjectNotExistsException e) {
            this.conv.queryAddUserToGroup(groupName, principal);
            return;
        }
        catch (GroupNotExistsException e) {
            this.conv.queryAddUserToGroup(groupName, principal);
            return;
        }
        this.conv.queryAddUserToGroup(groupName, principal);
    }

    public Group doGetGroup(String groupName) throws ServiceException, SecurityException {
        return this.conv.queryGetGroup(groupName);
    }

    public Set doGetGroupNames() throws SecurityException, ServiceException {
        return this.conv.queryGetGroupNames();
    }

    public Group[] doGetGroupList() throws ServiceException, SecurityException {
        return this.conv.queryGetGroupList();
    }

    public void doRemoveGroup(String groupName) throws ServiceException, SecurityException {
        try {
            super.doRemoveGroup(groupName);
        }
        catch (GroupNotExistsException e) {
            this.conv.queryRemoveGroup(groupName);
            return;
        }
        this.conv.queryRemoveGroup(groupName);
    }

    public void doRemoveUserFromGroup(String groupName, Principal principal) throws ServiceException, SecurityException {
        try {
            super.doRemoveUserFromGroup(groupName, principal);
        }
        catch (SubjectNotExistsException e) {
            this.conv.queryRemoveUserFromGroup(groupName, principal);
            return;
        }
        catch (GroupNotExistsException e) {
            this.conv.queryRemoveUserFromGroup(groupName, principal);
            return;
        }
        this.conv.queryRemoveUserFromGroup(groupName, principal);
    }

    public boolean doIsMember(String groupName, Principal principal) throws ServiceException {
        return this.conv.queryIsMember(groupName, principal);
    }

    public Enumeration doGetMembersFromGroup(String groupName) throws ServiceException {
        return this.conv.queryGetMembersFromGroup(groupName);
    }

    public void refreshRepositryService() throws ServiceException {
    }
}

