/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Principal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import jeus.security.base.CredentialFactory;
import jeus.security.base.PropertyHolder;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.db.CredentialTable;
import jeus.security.impl.atnrep.db.GroupMemberTable;
import jeus.security.impl.atnrep.db.PrincipalTable;
import jeus.security.impl.atnrep.db.PropertyTable;
import jeus.security.impl.atnrep.db.SubjectTable;
import jeus.security.util.Constants;
import jeus.security.util.DBConverter;
import jeus.security.util.InstanceMaker;

public class DBSubjectsConverter
extends DBConverter {
    private String domainName;
    private SubjectTable subjectTable = null;
    private PrincipalTable principalTable = null;
    private CredentialTable credentialTable = null;
    private PropertyTable propertyTable = null;
    private GroupMemberTable groupTable = null;

    public DBSubjectsConverter(String domainName, String vendor, String driver, String url, String username, String password) throws Exception {
        super(driver, url, username, password);
        this.domainName = domainName;
        this.vendor = vendor;
        this.create();
    }

    protected Object fromDBTable() throws Exception {
        super.close();
        Vector<Subject> v = new Vector<Subject>();
        ResultSet subjectResultSet = this.executeSelectQuery(this.subjectTable.getSelectQuery(), new String[]{this.domainName});
        while (subjectResultSet.next()) {
            SubjectTable subject = this.subjectTable.getObject(subjectResultSet);
            ResultSet principalResultSet = this.executeSelectQuery(this.principalTable.getPrinicpalQuery(), new String[]{subject.getSubjectId()});
            if (!principalResultSet.next()) {
                throw new Exception("principal does not exist");
            }
            PrincipalTable prince = this.principalTable.getObject(principalResultSet);
            String clazz = prince.getClassname() == null ? Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
            Principal thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
            Subject cur = new Subject(this.domainName, thePrince);
            while (principalResultSet.next()) {
                PrincipalTable group = this.principalTable.getObject(principalResultSet);
                String grClazz = group.getClassname() == null ? Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME : group.getClassname();
                cur.getPrincipals().add(InstanceMaker.makeInstance(grClazz, new Object[]{group.getName()}));
            }
            principalResultSet.close();
            ResultSet credentialResultSet = this.executeSelectQuery(this.credentialTable.getSelectQuery(), new String[]{prince.getSubjectId()});
            while (credentialResultSet.next()) {
                CredentialTable cred = this.credentialTable.getObject(credentialResultSet);
                String cfClazz = cred.getClassname() == null ? Constants.DEFAULT_CREDENTIAL_FACTORY_IMPL_CLASSNAME : cred.getClassname();
                CredentialFactory factory = (CredentialFactory)InstanceMaker.makeInstance(cfClazz, null);
                ResultSet propertyResultSet = this.executeSelectQuery(this.propertyTable.getSelectQuery(), new String[]{cred.getCredentialId()});
                this.setProps(factory, propertyResultSet);
                propertyResultSet.close();
                cur.getCredentialFactories().add(factory);
            }
            credentialResultSet.close();
            v.add(cur);
        }
        subjectResultSet.close();
        return v.toArray(new Subject[v.size()]);
    }

    protected Object fromDBTable(String principalName) throws Exception {
        super.connect();
        Vector<Object> v = new Vector<Object>();
        ResultSet principalResultSet = this.executeSelectQuery(this.principalTable.getSelectQuery(), new String[]{principalName});
        if (principalResultSet.next()) {
            ResultSet subjectResultSet = this.executeSelectQuery(this.subjectTable.getDomainQuery(), new String[]{principalResultSet.getString("subjectid")});
            while (subjectResultSet.next()) {
                if (!subjectResultSet.getString("domain").equals(this.domainName)) continue;
                PrincipalTable prince = this.principalTable.getObject(principalResultSet);
                Principal thePrince = null;
                Subject cur = null;
                String clazz = null;
                if (prince.isIsuser()) {
                    clazz = prince.getClassname() == null ? Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
                    thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
                    cur = new Subject(this.domainName, thePrince);
                    v.add(cur);
                    String subjectId = prince.getSubjectId();
                    String otherSubjectId = null;
                    Subject newcur = null;
                    while (principalResultSet.next()) {
                        prince = this.principalTable.getObject(principalResultSet);
                        otherSubjectId = prince.getSubjectId();
                        if (newcur == null || !subjectId.equals(otherSubjectId)) {
                            clazz = prince.getClassname() == null ? Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
                            thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
                            newcur = new Subject(this.domainName, thePrince, prince.isIsuser());
                            v.add(newcur);
                        } else {
                            clazz = prince.getClassname() == null ? Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
                            thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
                            newcur.getPrincipals().add(thePrince);
                        }
                        subjectId = otherSubjectId;
                    }
                } else {
                    clazz = prince.getClassname() == null ? Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
                    ResultSet groupResultSet = this.executeSelectQuery(this.groupTable.getPrinicpalQuery(), new String[]{this.domainName, prince.getName()});
                    if (groupResultSet != null && groupResultSet.getFetchSize() <= 0) {
                        throw new Exception("group does not exist");
                    }
                    while (groupResultSet.next()) {
                        GroupMemberTable group = this.groupTable.getObject(groupResultSet);
                        v.addAll(Arrays.asList(this.getSubjectObj(group.getUserName())));
                    }
                    thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
                    cur = new Subject(this.domainName, thePrince);
                    v.add(cur);
                    groupResultSet.close();
                }
                ResultSet credentialResultSet = this.executeSelectQuery(this.credentialTable.getSelectQuery(), new String[]{prince.getSubjectId()});
                while (credentialResultSet.next()) {
                    CredentialTable cred = this.credentialTable.getObject(credentialResultSet);
                    String cfClazz = cred.getClassname() == null ? Constants.DEFAULT_CREDENTIAL_FACTORY_IMPL_CLASSNAME : cred.getClassname();
                    CredentialFactory factory = (CredentialFactory)InstanceMaker.makeInstance(cfClazz, null);
                    ResultSet propertyResultSet = this.executeSelectQuery(this.propertyTable.getSelectQuery(), new String[]{cred.getCredentialId()});
                    this.setProps(factory, propertyResultSet);
                    propertyResultSet.close();
                    cur.getCredentialFactories().add(factory);
                }
                subjectResultSet.close();
                principalResultSet.close();
                credentialResultSet.close();
            }
        }
        return v.toArray(new Subject[v.size()]);
    }

    private Object[] getSubjectObj(String principalName) throws Exception {
        Vector<Subject> v = new Vector<Subject>();
        ResultSet principalResultSet = this.executeSelectQuery(this.principalTable.getSelectQuery(), new String[]{principalName});
        if (!principalResultSet.next()) {
            throw new Exception("principal does not exist");
        }
        PrincipalTable prince = this.principalTable.getObject(principalResultSet);
        String clazz = prince.getClassname() == null ? Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
        Principal thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
        Subject cur = new Subject(this.domainName, thePrince);
        v.add(cur);
        String subjectId = prince.getSubjectId();
        String otherSubjectId = null;
        Subject newcur = null;
        while (principalResultSet.next()) {
            prince = this.principalTable.getObject(principalResultSet);
            otherSubjectId = prince.getSubjectId();
            if (newcur == null || !subjectId.equals(otherSubjectId)) {
                clazz = prince.getClassname() == null ? Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
                thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
                newcur = new Subject(this.domainName, thePrince);
                v.add(newcur);
            } else {
                clazz = prince.getClassname() == null ? Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME : prince.getClassname();
                thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{prince.getName()});
                newcur.getPrincipals().add(thePrince);
            }
            subjectId = otherSubjectId;
        }
        principalResultSet.close();
        return v.toArray(new Subject[v.size()]);
    }

    private void setProps(PropertyHolder prop, ResultSet props) throws Exception {
        while (props.next()) {
            PropertyTable pt = this.propertyTable.getObject(props);
            String name = pt.getName();
            String value = pt.getValue();
            if (value != null) {
                prop.setProperty(name, value);
                continue;
            }
            prop.setProperty(name, "true");
        }
    }

    protected void toDBTable(Object object) throws Exception {
        super.connect();
        Vector querys = new Vector();
        Subject[] infos = (Subject[])object;
        this.addToDB(infos, querys);
        String[] queryList = new String[querys.size()];
        querys.toArray(queryList);
        this.executeUpdate(queryList);
        super.close();
    }

    private void addToDB(Subject[] infos, Vector querys) throws Exception {
        ResultSet seqNoResultSet = this.executeSelectQuery(this.seqNoTable.getSelectQuery(), new String[]{"jeus_subject"});
        int currentSeqno = Integer.parseInt(seqNoResultSet.getString("currentseqno"));
        ++currentSeqno;
        for (int i = 0; i < infos.length; ++i) {
            Subject info = infos[i];
            String mainPrincipalName = info.getPrincipal().getName();
            String mainSubjectId = null;
            this.principalTable.setClassname(info.getPrincipal().getClass().getName());
            this.principalTable.setName(mainPrincipalName);
            this.principalTable.setIsuser(true);
            ResultSet principalResultSet = this.executeSelectQuery(this.principalTable.getSelectQuery(), new String[]{mainPrincipalName});
            if (principalResultSet.getRow() == 0) {
                this.subjectTable.setDomain(info.getDomainName());
                this.subjectTable.setSubjectId(Integer.toString(currentSeqno));
                this.subjectTable.setDescription(info.getDescription());
                querys.add(this.subjectTable.execInsertQuery());
                this.principalTable.setSubjectId(Integer.toString(currentSeqno));
                querys.add(this.principalTable.execInsertQuery());
                mainSubjectId = Integer.toString(currentSeqno);
                ++currentSeqno;
            } else {
                ResultSet subjectResultSet = this.executeSelectQuery(this.subjectTable.getDomainQuery(), new String[]{principalResultSet.getString("subjectid")});
                while (subjectResultSet.next()) {
                    if (!subjectResultSet.getString("domain").equals(this.domainName)) continue;
                    mainSubjectId = subjectResultSet.getString("subjectid");
                    this.principalTable.setSubjectId(mainSubjectId);
                    querys.add(this.principalTable.execUpdateQuery());
                }
                subjectResultSet.close();
            }
            principalResultSet.close();
            for (Principal principal : info.getPrincipals()) {
                if (((Object)principal).equals(info.getPrincipal())) continue;
                String principalName = principal.getName();
                this.principalTable.setClassname(principal.getClass().getName());
                this.principalTable.setName(principalName);
                this.principalTable.setIsuser(false);
                principalResultSet = this.executeSelectQuery(this.principalTable.getSelectQuery(), new String[]{principalName});
                if (principalResultSet.getRow() == 0) {
                    this.subjectTable.setDomain(info.getDomainName());
                    this.subjectTable.setSubjectId(Integer.toString(currentSeqno));
                    this.subjectTable.setDescription(info.getDescription());
                    querys.add(this.subjectTable.execInsertQuery());
                    this.principalTable.setSubjectId(Integer.toString(currentSeqno));
                    querys.add(this.principalTable.execInsertQuery());
                    ++currentSeqno;
                } else {
                    ResultSet subjectResultSet = this.executeSelectQuery(this.subjectTable.getDomainQuery(), new String[]{principalResultSet.getString("subjectid")});
                    while (subjectResultSet.next()) {
                        if (!subjectResultSet.getString("domain").equals(this.domainName)) continue;
                        this.principalTable.setSubjectId(subjectResultSet.getString("subjectid"));
                        querys.add(this.principalTable.execUpdateQuery());
                    }
                    subjectResultSet.close();
                }
                principalResultSet.close();
            }
            Iterator iter = infos[i].getCredentialFactories().iterator();
            querys.add(this.credentialTable.getDeleteQuery());
            querys.add(this.propertyTable.getDeleteQuery());
            int id = 1;
            while (iter.hasNext()) {
                CredentialFactory factory = (CredentialFactory)iter.next();
                this.credentialTable.setCredentialId(Integer.toString(id));
                this.credentialTable.setSubjectId(mainSubjectId);
                this.credentialTable.setClassname(factory.getClass().getName());
                querys.add(this.credentialTable.execInsertQuery());
                Enumeration en = factory.propertyNames();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    String value = factory.getProperty(name);
                    this.propertyTable.setCredentialId(this.credentialTable.getCredentialId());
                    this.propertyTable.setName(name);
                    if (value != null && !value.equals("true")) {
                        this.propertyTable.setValue(value);
                    }
                    querys.add(this.propertyTable.execInsertQuery());
                }
                ++id;
            }
            querys.add(this.seqNoTable.execUpdateQuery(Integer.toString(id - 1), "jeus_credential"));
        }
        seqNoResultSet.close();
        querys.add(this.seqNoTable.execUpdateQuery(Integer.toString(currentSeqno - 1), "jeus_subject"));
    }

    public void create() throws Exception {
        this.subjectTable = new SubjectTable(this.vendor, this.domainName);
        this.principalTable = new PrincipalTable(this.vendor);
        this.credentialTable = new CredentialTable(this.vendor);
        this.propertyTable = new PropertyTable(this.vendor);
        this.groupTable = new GroupMemberTable(this.vendor, this.domainName);
        if (!super.checkExist(this.subjectTable.getCheckquery(), this.domainName)) {
            this.createSeqNoTable();
            ArrayList<String> createSqlList = new ArrayList<String>();
            createSqlList.add(this.subjectTable.getCreateQuery());
            createSqlList.add(this.principalTable.getCreateQuery());
            createSqlList.add(this.groupTable.getCreateQuery());
            createSqlList.add(this.credentialTable.getCreateQuery());
            createSqlList.add(this.propertyTable.getCreateQuery());
            ArrayList initDataSqlList = new ArrayList();
            initDataSqlList.addAll(this.subjectTable.getInitQuery());
            initDataSqlList.addAll(this.principalTable.getInitQuery());
            initDataSqlList.addAll(this.groupTable.getInitQuery());
            initDataSqlList.addAll(this.credentialTable.getInitQuery());
            initDataSqlList.addAll(this.propertyTable.getInitQuery());
            ArrayList<String> dropSqlList = new ArrayList<String>();
            dropSqlList.add(this.subjectTable.getDropQuery());
            dropSqlList.add(this.principalTable.getDropQuery());
            dropSqlList.add(this.groupTable.getDropQuery());
            dropSqlList.add(this.credentialTable.getDropQuery());
            dropSqlList.add(this.propertyTable.getDropQuery());
            String[] dropSqls = new String[dropSqlList.size()];
            dropSqlList.toArray(dropSqls);
            String[] createSqls = new String[createSqlList.size()];
            createSqlList.toArray(createSqls);
            String[] initDataSqls = new String[initDataSqlList.size()];
            initDataSqlList.toArray(initDataSqls);
            super.create(createSqls, initDataSqls);
        }
    }
}

