/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.MemoryAuthenticationRepositoryService;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;

public class DistributedMemoryAuthenticationRepositoryService
extends MemoryAuthenticationRepositoryService {
    private long getSynchTrigger() {
        String s = this.getProperty("synchtrigger");
        if (s != null) {
            return Long.parseLong(s);
        }
        return 15000L;
    }

    protected void doCreate() throws ServiceException, SecurityException {
        Set remoteSubjects;
        super.doCreate();
        Environment env = this.getRemoteEnvToDownloadFrom();
        if (env != null && (remoteSubjects = this.getRemoteSubjects(env)) != null && remoteSubjects.size() > 0) {
            for (Subject s : remoteSubjects) {
                this.subjectContainer.addSubject(s);
            }
        }
    }

    protected void doAddSubject(Subject subject) throws ServiceException, SecurityException {
        super.doAddSubject(subject);
        NetworkService.sendMessage(new NetworkMessage(4, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{subject}), true);
    }

    protected void doRemoveSubject(Subject subject) throws ServiceException, SecurityException {
        super.doRemoveSubject(subject);
        NetworkService.sendMessage(new NetworkMessage(5, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{subject}), true);
    }

    public void doAddSubject(Subject subject, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddSubject(subject);
        if (!localAdd) {
            NetworkService.sendMessage(new NetworkMessage(4, LoginService.getCurrentSubject(), 1, new Serializable[]{subject}), true);
        }
    }

    public void doRemoveSubject(Subject subject, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemoveSubject(subject);
        if (!localRemove) {
            NetworkService.sendMessage(new NetworkMessage(5, LoginService.getCurrentSubject(), 1, new Serializable[]{subject}), true);
        }
    }

    protected void doRemoveSubject(String name) throws ServiceException, SecurityException {
        super.doRemoveSubject(name);
        NetworkService.sendMessage(new NetworkMessage(6, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{name}), true);
    }

    public void doAddGroup(Group group) throws SecurityException, ServiceException {
        super.doAddGroup(group);
        NetworkService.sendMessage(new NetworkMessage(21, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{(GroupPrincipalImpl)group}), true);
    }

    public void doAddUserToGroup(String groupName, Principal principal) throws SecurityException, ServiceException {
        super.doAddUserToGroup(groupName, principal);
        NetworkService.sendMessage(new NetworkMessage(22, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName, (PrincipalImpl)principal}), true);
    }

    public void doRemoveGroup(String groupName) throws SecurityException, ServiceException {
        super.doRemoveGroup(groupName);
        NetworkService.sendMessage(new NetworkMessage(23, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName}), true);
    }

    public void doRemoveUserFromGroup(String groupName, Principal principal) throws SecurityException, ServiceException {
        super.doRemoveUserFromGroup(groupName, principal);
        NetworkService.sendMessage(new NetworkMessage(24, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{groupName, (PrincipalImpl)principal}), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getRemoteSubjects(Environment env) throws ServiceException, SecurityException {
        LoginService.loginCodeSubject();
        HashSet<Subject> result = null;
        try {
            Set names = (Set)NetworkService.sendMessage(new NetworkMessage(3, LoginService.getCurrentSubject(), null), false, env);
            Iterator iter = names.iterator();
            result = new HashSet<Subject>();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Subject s = (Subject)NetworkService.sendMessage(new NetworkMessage(2, LoginService.getCurrentSubject(), new Serializable[]{name}), false, env);
                result.add(s);
            }
        }
        finally {
            LoginService.logout();
        }
        return result;
    }

    private Environment getRemoteEnvToDownloadFrom() throws SecurityException, ServiceException {
        long now = System.currentTimeMillis();
        Environment[] remoteEnvs = NetworkService.getRemoteEnvironments();
        if (remoteEnvs == null) {
            return null;
        }
        for (int i = 0; i < remoteEnvs.length; ++i) {
            if (remoteEnvs[i].startTime == -1L || Math.abs(now - remoteEnvs[i].startTime) <= this.getSynchTrigger() || !remoteEnvs[i].master) continue;
            return remoteEnvs[i];
        }
        return null;
    }
}

