/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Permission;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.SubjectMo;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.CacheInfo;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SubjectNotExistsException;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.SubjectManager;

public class JeusMemoryAuthenticationRepositoryService
extends AuthenticationRepositoryService {
    protected SubjectManager subjectManager;
    protected SubjectMo subjectMo;

    protected void doCreate() throws ServiceException, SecurityException {
        CacheInfo cacheInfo = this.getDomain().getCacheInfo();
        if (cacheInfo == null) {
            cacheInfo = new CacheInfo(20, 100, 1800000L);
            this.getDomain().setCacheInfo(cacheInfo);
            this.subjectManager = new SubjectManager(cacheInfo.getMin(), cacheInfo.getMax(), cacheInfo.getTimeout());
        } else {
            this.subjectManager = new SubjectManager(cacheInfo.getMin(), cacheInfo.getMax(), cacheInfo.getTimeout());
        }
    }

    protected void doDestroy() {
        this.subjectManager.stop();
        this.subjectManager.clear();
        this.subjectManager = null;
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.subjectMo = (SubjectMo)SubjectMo.createMBean("Subject", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Subject doGetSubject(String name) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectManager.getSubject(name);
    }

    protected Subject doGetSubject(Subject name) throws SubjectNotExistsException, ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectManager.getSubject(name.getPrincipal().getName());
    }

    protected Set doGetSubjectNames() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectManager.getSubjectNames();
    }

    protected Subject[] doGetSubjectsAsArray() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectManager.getSubjectsAsArray();
    }

    protected void doAddSubject(Subject subject) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_SUBJECT_PERMISSION);
        this.subjectManager.addSubject(subject);
    }

    protected void doRemoveSubject(Subject subject) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_SUBJECT_PERMISSION);
        this.subjectManager.removeSubject(subject);
    }

    public void doAddSubject(Subject subject, boolean localAdd) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_SUBJECT_PERMISSION);
        this.subjectManager.addSubject(subject);
    }

    public void doRemoveSubject(Subject subject, boolean localRemove) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_SUBJECT_PERMISSION);
        this.subjectManager.removeSubject(subject);
    }

    protected void doRemoveSubject(String name) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_SUBJECT_PERMISSION);
        this.subjectManager.removeSubject(name);
    }

    public void doSave() throws ServiceException, SecurityException {
    }

    public boolean doUserExists(String userName) {
        return this.subjectManager.userExists(userName);
    }

    public boolean doGroupExist(String groupName) {
        return this.subjectManager.groupExist(groupName);
    }

    public void doAddGroup(Group group) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_GROUP_PERMISSION);
        this.subjectManager.addGroup(group);
    }

    public void doAddUserToGroup(String groupName, Principal principal) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_USER_TO_GROUP_PERMISSION);
        this.subjectManager.addUserToGroup(groupName, principal);
    }

    public Group doGetGroup(String groupName) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_GROUP_PERMISSION);
        return this.subjectManager.getGroup(groupName);
    }

    public Set doGetGroupNames() throws SecurityException, ServiceException {
        LoginService.checkPermission((Permission)GET_GROUP_LIST_PERMISSION);
        return this.subjectManager.getGroupNames();
    }

    public Group[] doGetGroupList() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_GROUP_LIST_PERMISSION);
        return this.subjectManager.getGroupList();
    }

    public void doRemoveGroup(String groupName) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_GROUP_PERMISSION);
        this.subjectManager.removeGroup(groupName);
    }

    public void doRemoveUserFromGroup(String groupName, Principal principal) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_GROUP_PERMISSION);
        this.subjectManager.removeUserToGroup(groupName, principal);
    }

    public boolean doIsMember(String groupName, Principal principal) throws ServiceException {
        return this.subjectManager.isMember(groupName, principal);
    }

    public Enumeration doGetMembersFromGroup(String groupName) throws ServiceException {
        return this.subjectManager.getMembersFromGroup(groupName);
    }

    public Object readSubjectsInRepository() throws ServiceException {
        return null;
    }

    public void writeSubjectsToRepository(Object subjects) throws ServiceException {
    }

    public void refreshRepositryService() throws ServiceException {
    }
}

