/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Permission;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.SubjectMo;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SubjectNotExistsException;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.SubjectContainer;

public class MemoryAuthenticationRepositoryService
extends AuthenticationRepositoryService {
    protected SubjectContainer subjectContainer;
    protected SubjectMo subjectMo = null;

    protected void doCreate() throws ServiceException, SecurityException {
        this.subjectContainer = new SubjectContainer();
    }

    protected void doDestroy() {
        this.subjectContainer.clear();
        this.subjectContainer = null;
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.subjectMo = (SubjectMo)SubjectMo.createMBean("Subject", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Subject doGetSubject(String name) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectContainer.getSubject(name);
    }

    protected Subject doGetSubject(Subject name) throws SubjectNotExistsException, ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectContainer.getSubject(name.getPrincipal().getName());
    }

    protected Set doGetSubjectNames() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectContainer.getSubjectNames();
    }

    protected Subject[] doGetSubjectsAsArray() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        return this.subjectContainer.getSubjectsAsArray();
    }

    protected void doAddSubject(Subject subject) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_SUBJECT_PERMISSION);
        this.subjectContainer.addSubject(subject);
    }

    protected void doRemoveSubject(Subject subject) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_SUBJECT_PERMISSION);
        this.subjectContainer.removeSubject(subject);
    }

    public void doAddSubject(Subject subject, boolean localAdd) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_SUBJECT_PERMISSION);
        this.subjectContainer.addSubject(subject);
    }

    public void doRemoveSubject(Subject subject, boolean localRemove) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_SUBJECT_PERMISSION);
        this.subjectContainer.removeSubject(subject);
    }

    protected void doRemoveSubject(String name) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_SUBJECT_PERMISSION);
        this.subjectContainer.removeSubject(name);
    }

    public void doSave() throws ServiceException {
    }

    public boolean doUserExists(String userName) {
        return this.subjectContainer.userExists(userName);
    }

    public boolean doGroupExist(String groupName) {
        return this.subjectContainer.groupExist(groupName);
    }

    public void doAddGroup(Group group) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_GROUP_PERMISSION);
        this.subjectContainer.addGroup(group);
    }

    public void doAddUserToGroup(String groupName, Principal principal) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_USER_TO_GROUP_PERMISSION);
        this.subjectContainer.addUserToGroup(groupName, principal);
    }

    public Group doGetGroup(String groupName) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_GROUP_PERMISSION);
        return this.subjectContainer.getGroup(groupName);
    }

    public Set doGetGroupNames() throws SecurityException, ServiceException {
        LoginService.checkPermission((Permission)GET_GROUP_LIST_PERMISSION);
        return this.subjectContainer.getGroupNames();
    }

    public Group[] doGetGroupList() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_GROUP_LIST_PERMISSION);
        return this.subjectContainer.getGroupList();
    }

    public void doRemoveGroup(String groupName) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_GROUP_PERMISSION);
        this.subjectContainer.removeGroup(groupName);
    }

    public void doRemoveUserFromGroup(String groupName, Principal principal) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_GROUP_PERMISSION);
        this.subjectContainer.removeUserToGroup(groupName, principal);
    }

    public boolean doIsMember(String groupName, Principal principal) throws ServiceException {
        return this.subjectContainer.isMember(groupName, principal);
    }

    public Enumeration doGetMembersFromGroup(String groupName) throws ServiceException {
        return this.subjectContainer.getMembersFromGroup(groupName);
    }

    public Object readSubjectsInRepository() throws ServiceException {
        return null;
    }

    public void writeSubjectsToRepository(Object subjects) throws ServiceException {
    }

    public void refreshRepositryService() throws ServiceException {
    }
}

