/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.io.File;
import java.math.BigInteger;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.management.ObjectName;
import jeus.security.base.SKI;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.atnrep.XMLCertUserMapConverter;
import jeus.security.impl.atnrep.XMLUserCertMapConverter;
import jeus.security.resource.SecretKeyInfo;
import jeus.security.resource.UserCertInfo;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.UserCertMappingService;
import jeus.security.util.Base64Coder;
import jeus.security.util.NameAndPathUtil;
import jeus.security.util.X509Util;

public class XMLUserCertMappingService
extends UserCertMappingService {
    private File userCertMapFile;
    private XMLUserCertMapConverter userCertMapConv;
    private File certUserMapFile;
    private XMLCertUserMapConverter certUserMapConv;
    private char[] keyStorePassword;

    protected void doCreate() throws ServiceException, SecurityException {
        String baseDir;
        super.doCreate();
        String filename = this.getProperty("filename");
        if (filename == null) {
            baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
            filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "user-cert-map.xml";
        }
        this.userCertMapFile = new File(filename);
        if (this.userCertMapFile.exists()) {
            try {
                this.keyStorePassword = this.getDomain().getKeyStorePass();
                this.userCertMapConv = new XMLUserCertMapConverter(this.userCertMap, new String(this.keyStorePassword));
                baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "cert-user-map.xml";
                this.certUserMapFile = new File(filename);
                if (this.certUserMapFile.exists()) {
                    this.certUserMapConv = new XMLCertUserMapConverter(this.certUserMap);
                }
                this.refreshRead();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.destroy();
        }
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    private void refreshRead() throws ServiceException {
        try {
            if (this.userCertMapConv != null) {
                this.userCertMapConv.unmarshal(this.userCertMapFile);
            }
            if (this.certUserMapConv != null) {
                this.certUserMapConv.unmarshal(this.certUserMapFile);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading user-cert-map.xml XML file: exception occured", e);
        }
    }

    public X509Certificate doGetCertInTrustStore(Principal subjectDN) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)this.trustStoreToCertMap.get(subjectDN.getName());
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInTrustStore(this.trustStore, subjectDN);
        if (cert != null) {
            this.trustStoreToCertMap.put(subjectDN.getName(), cert);
        }
        return cert;
    }

    public X509Certificate doGetCertInTrustStore(SKI ski) throws Exception {
        X509Certificate cert = (X509Certificate)this.trustStoreToCertMap.get(ski.getValue());
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInTrustStore(this.trustStore, ski);
        if (cert != null) {
            this.trustStoreToCertMap.put(ski.getValue(), cert);
        }
        return cert;
    }

    public X509Certificate doGetCertInTrustStore(Principal issuerDN, BigInteger serial) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)this.trustStoreToCertMap.get(issuerDN.getName() + serial);
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInTrustStore(this.trustStore, issuerDN, serial);
        if (cert != null) {
            this.trustStoreToCertMap.put(issuerDN.getName() + serial, cert);
        }
        return cert;
    }

    public X509Certificate doGetCertInKeyStore(Principal subjectDN) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)this.keyStoreToCertMap.get(subjectDN.getName());
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInKeyStore(this.keyStore, subjectDN);
        if (cert != null) {
            this.keyStoreToCertMap.put(subjectDN.getName(), cert);
        }
        return cert;
    }

    public X509Certificate doGetCertInKeyStore(SKI ski) throws Exception {
        X509Certificate cert = (X509Certificate)this.keyStoreToCertMap.get(ski.getValue());
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInKeyStore(this.keyStore, ski);
        if (cert != null) {
            this.keyStoreToCertMap.put(ski.getValue(), cert);
        }
        return cert;
    }

    public X509Certificate doGetCertInKeyStore(Principal issuerDN, BigInteger serial) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)this.keyStoreToCertMap.get(issuerDN.getName() + serial);
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInKeyStore(this.keyStore, issuerDN, serial);
        if (cert != null) {
            this.keyStoreToCertMap.put(issuerDN.getName() + serial, cert);
        }
        return cert;
    }

    public List doGetCertificates(String subject) throws ServiceException, SecurityException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        return X509Util.getCertificates(this.userCertMap, this.keyStore, subject, this.keyStorePassword);
    }

    public PrivateKey doGetPrivateKey(String subject) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, ServiceException, SecurityException {
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        PrivateKey privateKey = (PrivateKey)this.privateKeyMap.get(subject);
        if (privateKey != null) {
            return privateKey;
        }
        privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, subject, this.keyStorePassword);
        if (privateKey != null) {
            this.privateKeyMap.put(subject, privateKey);
        }
        return privateKey;
    }

    public PrivateKey doGetPrivateKey(Principal subjectDN) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException, ServiceException {
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        PrivateKey privateKey = (PrivateKey)this.privateKeyMap.get(subjectDN.getName());
        if (privateKey != null) {
            return privateKey;
        }
        String username = (String)this.certUserMap.get(subjectDN.getName());
        if (username != null) {
            privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, username, this.keyStorePassword);
        } else {
            privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, subjectDN, this.keyStorePassword);
            this.certUserMap.put(subjectDN.getName(), username);
        }
        if (privateKey != null) {
            this.privateKeyMap.put(subjectDN.getName(), privateKey);
        }
        return privateKey;
    }

    public PrivateKey doGetPrivateKey(SKI ski) throws Exception {
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        PrivateKey privateKey = (PrivateKey)this.privateKeyMap.get(ski.getValue());
        if (privateKey != null) {
            return privateKey;
        }
        String username = (String)this.certUserMap.get(ski.getValue());
        if (username != null) {
            privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, username, this.keyStorePassword);
        } else {
            privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, ski, this.keyStorePassword);
            this.certUserMap.put(ski.getValue(), username);
        }
        if (privateKey != null) {
            this.privateKeyMap.put(ski.getValue(), privateKey);
        }
        return privateKey;
    }

    public PrivateKey doGetPrivateKey(Principal issuerDN, BigInteger serial) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException, ServiceException {
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        PrivateKey privateKey = (PrivateKey)this.privateKeyMap.get(issuerDN.getName() + serial);
        if (privateKey != null) {
            return privateKey;
        }
        String username = (String)this.certUserMap.get(issuerDN.getName() + serial);
        if (username != null) {
            privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, username, this.keyStorePassword);
        } else {
            privateKey = X509Util.getPrivateKey(this.userCertMap, this.keyStore, issuerDN, serial, this.keyStorePassword);
            this.certUserMap.put(issuerDN.getName() + serial, username);
        }
        if (privateKey != null) {
            this.privateKeyMap.put(issuerDN.getName() + serial, privateKey);
        }
        return privateKey;
    }

    public boolean doIsValid(X509Certificate cert, boolean checkCRL) throws KeyStoreException {
        return X509Util.isValid(this.trustStore, this.keyStore, cert, checkCRL);
    }

    public String doGetSubjectInTrustStore(SKI ski) throws SecurityException {
        return X509Util.getAliasForX509Cert(this.trustStore, Base64Coder.base64ToByteArray(ski.getValue()));
    }

    public String doGetSubjectInTrustStore(Principal subjectDN) throws SecurityException {
        return X509Util.getAliasForDN(this.trustStore, subjectDN.getName());
    }

    public String doGetSubjectInTrustStore(Principal issuerDN, BigInteger serial) throws SecurityException {
        return X509Util.getAliasForX509Cert(this.trustStore, issuerDN.getName(), serial);
    }

    public String doGetSubjectInTrustStore(byte[] thumbprint) throws SecurityException {
        return X509Util.getAliasForX509CertThumb(this.trustStore, thumbprint);
    }

    public X509Certificate doGetCertInTrustStore(String subject) throws KeyStoreException, SecurityException {
        X509Certificate cert = (X509Certificate)this.trustStoreToCertMap.get(subject);
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInKeyStore(this.userCertMap, this.trustStore, subject);
        if (cert != null) {
            this.trustStoreToCertMap.put(subject, cert);
        }
        return cert;
    }

    public SecretKeyInfo doGetSecretKeyWithKeyName(String keyName) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        for (UserCertInfo info : this.userCertMap.values()) {
            SecretKeyInfo secretKeyInfo = info.getSecretKeyInfo();
            if (secretKeyInfo == null || !secretKeyInfo.getKeyname().equals(keyName)) continue;
            return secretKeyInfo;
        }
        return null;
    }

    public SecretKeyInfo doGetSecretKeyWithKeyUser(String user) throws ServiceException, SecurityException {
        SecretKeyInfo secretKeyInfo;
        LoginService.checkPermission((Permission)USER_CERT_MAPPING_PERMISSION);
        UserCertInfo info = (UserCertInfo)this.userCertMap.get(user);
        if (info != null && (secretKeyInfo = info.getSecretKeyInfo()) != null) {
            return secretKeyInfo;
        }
        return null;
    }

    public String doGetSubjectInKeyStore(SKI ski) throws Exception {
        return X509Util.getAliasForX509Cert(this.keyStore, Base64Coder.base64ToByteArray(ski.getValue()));
    }

    public String doGetSubjectInKeyStore(Principal subjectDN) throws SecurityException {
        return X509Util.getAliasForDN(this.keyStore, subjectDN.getName());
    }

    public String doGetSubjectInKeyStore(Principal issuerDN, BigInteger serial) throws SecurityException {
        return X509Util.getAliasForX509Cert(this.keyStore, issuerDN.getName(), serial);
    }

    public String doGetSubjectInKeyStore(byte[] thumbprint) throws SecurityException {
        return X509Util.getAliasForX509CertThumb(this.keyStore, thumbprint);
    }

    public X509Certificate doGetCertInKeyStore(String subject) throws KeyStoreException, SecurityException {
        X509Certificate cert = (X509Certificate)this.keyStoreToCertMap.get(subject);
        if (cert != null) {
            return cert;
        }
        cert = X509Util.getCertInKeyStore(this.userCertMap, this.keyStore, subject);
        if (cert != null) {
            this.keyStoreToCertMap.put(subject, cert);
        }
        return cert;
    }

    public String doGetUserInCert(String key) throws SecurityException, ServiceException {
        return (String)this.certUserMap.get(key);
    }
}

