/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.security.util.DBRepositoryTable;

public class GroupTable
extends DBRepositoryTable {
    String domain;
    String groupName;
    String description = "No Description";
    Vector subgroups = new Vector();

    public GroupTable(String vendor, String domain) {
        this.domain = domain;
        this.table = "jeus_groups";
        this.columns = new String[]{"domain", "groupname", "subgroups", "description"};
        this.columnsType = new String[]{"varchar2(30)", "varchar2(30)", "varchar2(100)", "varchar2(100)"};
        this.otherColumnsType = new String[]{"varchar(30)", "varchar(30)", "varchar(100)", "varchar(100)"};
        this.whereColumns = new String[]{"domain"};
        this.primaryKeyColumns = new String[]{"domain", "groupname"};
        super.initSQLBuilder(vendor);
    }

    public GroupTable() {
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String[] getSubgroups() {
        return this.subgroups.toArray(new String[this.subgroups.size()]);
    }

    public String getSubGroupNameList() {
        String[] subGroupList = this.getSubgroups();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < subGroupList.length; ++i) {
            buf.append(subGroupList[i]);
            buf.append(",");
        }
        buf.deleteCharAt(buf.toString().lastIndexOf(","));
        return buf.toString();
    }

    public void addSubgroups(String subgroups) {
        this.subgroups.add(subgroups);
    }

    public GroupTable getObject(ResultSet rs) throws SQLException {
        if (rs != null) {
            GroupTable obj = new GroupTable();
            obj.setDomain(rs.getString(this.columns[0]));
            obj.setGroupName(rs.getString(this.columns[1]));
            String subgroups = rs.getString(this.columns[2]);
            if (subgroups != null) {
                StringTokenizer token = new StringTokenizer(subgroups, ",");
                while (token.hasMoreElements()) {
                    obj.addSubgroups((String)token.nextElement());
                }
            }
            obj.setDescription(rs.getString(this.columns[3]));
            return obj;
        }
        return null;
    }

    public String execInsertQuery() {
        StringBuffer query = new StringBuffer("insert into " + this.table + " values(");
        query.append(this.convertNull(this.getDomain()) + ", ");
        query.append(this.convertNull(this.getGroupName()) + ", '");
        query.append(this.convertNull(this.getSubGroupNameList()) + "', ");
        query.append(this.convertNull(this.getDescription()) + ")");
        return query.toString();
    }

    public String execUpdateQuery() {
        StringBuffer query = new StringBuffer("update " + this.table + " set ");
        query.append("domain = " + this.convertNull(this.getDomain()) + ", ");
        query.append("groupname = " + this.convertNull(this.getGroupName()) + ", ");
        query.append("subgroups = '" + this.convertNull(this.getSubGroupNameList()) + "', ");
        query.append("description = " + this.convertNull(this.getDescription()));
        query.append(" where domain = " + this.convertNull(this.getDomain() + " and groupname = " + this.getGroupName()));
        return query.toString();
    }

    protected void initQuery() {
        this.list.add("insert into " + this.table + " values('SYSTEM_DOMAIN', 'system_group', null, 'Jeus System group')");
    }

    public String getGroupQuery() {
        return "select * from " + this.table + " where domain = ? and groupname = ? ";
    }
}

