/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.auditlog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.management.ObjectName;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NameAndPathUtil;

public class BasicAuditLogFileService
extends EventHandlingService {
    private FileOutputStream out;
    private PrintWriter pw;
    private Event.Level level = Event.WARNING;

    protected void doCreate() throws ServiceException, SecurityException {
        try {
            File theLogFile;
            String level = this.getProperty("audit.level");
            if (level != null) {
                this.level = new Event.Level(level);
            }
            String filename = this.getProperty("filename");
            String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
            if (filename == null) {
                filename = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "audit.log";
            }
            if (!(theLogFile = new File(filename)).exists()) {
                theLogFile.createNewFile();
                this.out = new FileOutputStream(theLogFile, true);
                this.pw = new PrintWriter(this.out);
                this.pw.println("Audit log file created on " + new Date());
            } else {
                this.out = new FileOutputStream(theLogFile, true);
                this.pw = new PrintWriter(this.out);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Error creating the BasicAuditLogFileService: unexpected exception occured", e);
        }
    }

    protected void doDestroy() {
        block5: {
            block4: {
                try {
                    this.pw.close();
                }
                catch (Exception e) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._15_LEVEL)) break block4;
                    LoggerUtil.logger.log(JeusMessage_Security._15_LEVEL, JeusMessage_Security._15, (Throwable)e);
                }
            }
            try {
                this.out.close();
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._16_LEVEL)) break block5;
                LoggerUtil.logger.log(JeusMessage_Security._16_LEVEL, JeusMessage_Security._16, (Throwable)e);
            }
        }
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected void doHandleEvent(Event event) {
        this.pw.println(event.toString());
        if (event.getType().equals("security.install.successful")) {
            this.pw.println(event.getEnvironment().toString());
        }
    }

    protected boolean doHandlesEvent(Event event) {
        return event.getType().startsWith("security") && event.getLevel().hasHigherOrSamePriorityAs(this.level);
    }
}

