/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.azn;

import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.azn.DefaultContextHandler;
import jeus.security.spi.AuthorizationService;

public class JACCAuthorizationService
extends AuthorizationService {
    protected synchronized void doCreate() throws ServiceException {
        try {
            DefaultContextHandler handler = new DefaultContextHandler();
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)true);
            PolicyContext.registerHandler((String)"javax.xml.soap.SOAPMessage", (PolicyContextHandler)handler, (boolean)true);
            PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)handler, (boolean)true);
            PolicyContext.registerHandler((String)"javax.ejb.EnterpriseBean", (PolicyContextHandler)handler, (boolean)true);
            PolicyContext.registerHandler((String)"javax.ejb.arguments", (PolicyContextHandler)handler, (boolean)true);
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating the JACCAuthorizationService: exception occured", e);
        }
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected void doAuthorize(String contextId, Permission permission, Subject subject) throws ServiceException, SecurityException {
        Principal[] principals = new Principal[]{};
        if (subject != null) {
            principals = subject.getPrincipals().toArray(new Principal[0]);
        }
        ProtectionDomain newPd = new ProtectionDomain(null, null, null, principals);
        Policy policy = Policy.getPolicy();
        PolicyContext.setContextID((String)contextId);
        boolean result = policy.implies(newPd, permission);
        PolicyContext.setContextID(null);
        if (!result) {
            throw new SecurityException("Authorization failed: the JACC provider denied the permission");
        }
    }
}

