/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.security.Permission;
import java.security.Principal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.PolicyFactory;
import jeus.security.base.Role;
import jeus.security.impl.aznrep.db.ResourcePermissionTable;
import jeus.security.impl.aznrep.db.ResourcePermissionsTable;
import jeus.security.impl.aznrep.db.ResourceRoleTable;
import jeus.security.impl.aznrep.db.RolePermissionTable;
import jeus.security.impl.aznrep.db.RolePermissionsTable;
import jeus.security.impl.aznrep.db.RolePrincipalTable;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RoleImpl;
import jeus.security.util.DBConverter;
import jeus.security.util.PermissionMaker;

public class CustomJeusDBPoliciesConverter
extends DBConverter {
    private String domainName;
    private ResourcePermissionsTable resourcePermissionsTable = null;
    private ResourcePermissionTable resourcePermissionTable = null;
    private ResourceRoleTable resourceRoleTable = null;
    private RolePermissionsTable rolePermissionsTable = null;
    private RolePermissionTable rolePermissionTable = null;
    private RolePrincipalTable rolePrincipalTable = null;
    private String customPolicyClassName = null;

    public CustomJeusDBPoliciesConverter(String domainName, String vendor, String driver, String url, String username, String password, String customPolicyClassName) throws Exception {
        super(driver, url, username, password);
        this.domainName = domainName;
        this.vendor = vendor;
        this.customPolicyClassName = customPolicyClassName;
        this.create();
    }

    protected Object fromDBTable() throws Exception {
        super.connect();
        Vector<Policy> v = new Vector<Policy>();
        Policy dpc = PolicyFactory.getPolicyFactory(this.customPolicyClassName);
        ResultSet rolePermissionsResultSet = this.executeSelectQuery(this.rolePermissionsTable.getSelectQuery(), new String[]{this.domainName});
        while (rolePermissionsResultSet.next()) {
            ResultSet rolePermissionResultSet = this.executeSelectQuery(this.rolePermissionTable.getSelectQuery(), new String[]{this.rolePermissionsTable.getObject(rolePermissionsResultSet).getRolePermissionId()});
            dpc.getRolePolicy().add(this.loadRolePermissions(rolePermissionResultSet));
            rolePermissionResultSet.close();
        }
        rolePermissionsResultSet.close();
        ResultSet resourcePermissionsResultSet = this.executeSelectQuery(this.resourcePermissionsTable.getSelectQuery(), new String[]{this.domainName});
        while (resourcePermissionsResultSet.next()) {
            ResourcePermissionsTable resourcePermissions = this.resourcePermissionsTable.getObject(resourcePermissionsResultSet);
            ResultSet resourcePermissionResultSet = this.executeSelectQuery(this.resourcePermissionTable.getSelectQuery(), new String[]{resourcePermissions.getResourcePermissionId()});
            while (resourcePermissionResultSet.next()) {
                dpc.getResourcePolicy(resourcePermissions.getContextId(), true).add(this.loadResourcePermissions(resourcePermissionResultSet));
            }
            resourcePermissionResultSet.close();
        }
        resourcePermissionsResultSet.close();
        v.add(dpc);
        return v.toArray();
    }

    protected Object fromDBTable(String contextId) throws Exception {
        super.connect();
        Policy dpc = PolicyFactory.getPolicyFactory(this.customPolicyClassName);
        ResultSet rolePermissionsResultSet = this.executeSelectQuery(this.rolePermissionsTable.getSelectQuery(), new String[]{this.domainName});
        while (rolePermissionsResultSet.next()) {
            ResultSet rolePermissionResultSet = this.executeSelectQuery(this.rolePermissionTable.getSelectQuery(), new String[]{this.rolePermissionsTable.getObject(rolePermissionsResultSet).getRolePermissionId()});
            dpc.getRolePolicy().add(this.loadRolePermissions(rolePermissionResultSet));
            rolePermissionResultSet.close();
        }
        rolePermissionsResultSet.close();
        ResultSet resourcePermissionsResultSet = this.executeSelectQuery(this.resourcePermissionsTable.getSelectQuery(), new String[]{this.domainName, contextId});
        while (resourcePermissionsResultSet.next()) {
            ResourcePermissionsTable resourcePermissions = this.resourcePermissionsTable.getObject(resourcePermissionsResultSet);
            ResultSet resourcePermissionResultSet = this.executeSelectQuery(this.resourcePermissionTable.getSelectQuery(), new String[]{resourcePermissions.getResourcePermissionId()});
            while (resourcePermissionResultSet.next()) {
                dpc.getResourcePolicy(contextId, true).add(this.loadResourcePermissions(resourcePermissionResultSet));
            }
            resourcePermissionResultSet.close();
        }
        resourcePermissionsResultSet.close();
        return dpc;
    }

    public PermissionMap getRolePolicy() throws Exception {
        PermissionMap principalRolePolicy = new PermissionMap();
        ResultSet rolePermissionsResultSet = this.executeSelectQuery(this.rolePermissionsTable.getSelectQuery(), new String[]{this.domainName});
        while (rolePermissionsResultSet.next()) {
            ResultSet rolePermissionResultSet = this.executeSelectQuery(this.rolePermissionTable.getSelectQuery(), new String[]{this.rolePermissionsTable.getObject(rolePermissionsResultSet).getRolePermissionId()});
            principalRolePolicy.add(this.loadRolePermissions(rolePermissionResultSet));
            rolePermissionResultSet.close();
        }
        rolePermissionsResultSet.close();
        return principalRolePolicy;
    }

    private PermissionMap loadRolePermissions(ResultSet rolePermissionResultSet) throws Exception {
        PermissionMap pc = new PermissionMap();
        while (rolePermissionResultSet.next()) {
            RolePermissionTable rolePermission = this.rolePermissionTable.getObject(rolePermissionResultSet);
            Permission p = PermissionMaker.makePermission((String)rolePermission.getClassname(), (String)rolePermission.getRole(), (String)rolePermission.getActions());
            boolean excluded = rolePermission.isExcluded();
            boolean unchecked = rolePermission.isUnchecked();
            Vector<PrincipalImpl> principals = new Vector<PrincipalImpl>();
            ResultSet rolePrincipalResultSet = this.executeSelectQuery(this.rolePrincipalTable.getSelectQuery(), new String[]{this.domainName, rolePermission.getRolePermissionId()});
            while (rolePrincipalResultSet.next()) {
                RolePrincipalTable rolePrincipal = this.rolePrincipalTable.getObject(rolePrincipalResultSet);
                principals.add(new PrincipalImpl(rolePrincipal.getUsername()));
            }
            rolePrincipalResultSet.close();
            Object[] princes = principals.toArray();
            pc.addPermission(p, princes, excluded, unchecked);
        }
        return pc;
    }

    private PermissionMap loadResourcePermissions(ResultSet resourcePermissionsResultSet) throws Exception {
        PermissionMap pc = new PermissionMap(true);
        ResourcePermissionTable rp = this.resourcePermissionTable.getObject(resourcePermissionsResultSet);
        Permission p = PermissionMaker.makePermission((String)rp.getClassname(), (String)rp.getResource(), (String)rp.getActions());
        boolean excluded = rp.isExcluded();
        boolean unchecked = rp.isUnchecked();
        Vector<RoleImpl> roles = new Vector<RoleImpl>();
        ResultSet resourceRoleResultSet = this.executeSelectQuery(this.resourceRoleTable.getSelectQuery(), new String[]{this.domainName, rp.getResourcePermissionId()});
        while (resourceRoleResultSet.next()) {
            ResourceRoleTable resourceRole = this.resourceRoleTable.getObject(resourceRoleResultSet);
            ResultSet roleResultSet = this.executeSelectQuery(this.rolePermissionTable.getSelectQuery(), new String[]{resourceRole.getRolePermissionId()});
            while (roleResultSet.next()) {
                roles.add(new RoleImpl(roleResultSet.getString("role")));
            }
            roleResultSet.close();
        }
        resourceRoleResultSet.close();
        Object[] rls = roles.toArray();
        pc.addPermission(p, rls, excluded, unchecked);
        return pc;
    }

    protected void toDBTable(Object object) throws Exception {
        super.connect();
        Vector querys = new Vector();
        Policy[] dpcs = (Policy[])object;
        for (int i = 0; i < dpcs.length; ++i) {
            this.savePolicy(dpcs[i], querys);
        }
        String[] queryList = new String[querys.size()];
        querys.toArray(queryList);
        this.executeUpdate(queryList);
        super.close();
    }

    private void savePolicy(Policy ap, Vector querys) throws Exception {
        ResultSet seqNoResultSet = this.executeSelectQuery(this.seqNoTable.getSelectQuery(), new String[]{"jeus_role_permission"});
        int currentSeqno = Integer.parseInt(seqNoResultSet.getString("currentseqno"));
        PermissionMap prPC = ap.getRolePolicy();
        this.saveRolePermission(++currentSeqno, prPC, querys);
        querys.add(this.seqNoTable.execUpdateQuery(Integer.toString(currentSeqno - 1), "jeus_role_permission"));
        seqNoResultSet = this.executeSelectQuery(this.seqNoTable.getSelectQuery(), new String[]{"jeus_resource_permission"});
        currentSeqno = Integer.parseInt(seqNoResultSet.getString("currentseqno"));
        ++currentSeqno;
        seqNoResultSet.close();
        for (String contextId : ap.getResourcePolicyIds()) {
            PermissionMap pm = ap.getResourcePolicy(contextId);
            if (pm == null) continue;
            this.saveResourcePermission(currentSeqno, pm, contextId, querys);
        }
        querys.add(this.seqNoTable.execUpdateQuery(Integer.toString(currentSeqno - 1), "jeus_resource_permission"));
    }

    private void saveRolePermission(int currentIdx, PermissionMap pc, Vector querys) throws Exception {
        for (Permission p : pc.getAllPermissions()) {
            this.rolePermissionTable.setRole(p.getName());
            this.rolePermissionTable.setClassname(p.getClass().getName());
            if (p.getActions() != null) {
                this.rolePermissionTable.setActions(p.getActions());
            }
            if (pc.getExcludedPermissions().contains(p)) {
                this.rolePermissionTable.setExcluded(true);
            }
            if (pc.getUncheckedPermissions().contains(p)) {
                this.rolePermissionTable.setUnchecked(true);
            }
            ResultSet roleIdResultSet = this.executeSelectQuery(this.rolePermissionTable.getSelectQuery(), new String[]{p.getName()});
            String rolePermissionId = null;
            querys.add(this.rolePrincipalTable.getDeleteQuery());
            if (roleIdResultSet.getRow() == 0) {
                querys.add(this.rolePermissionTable.execInsertQuery());
                this.rolePermissionsTable.setDomain(this.domainName);
                this.rolePermissionsTable.setRolePermissionId(Integer.toString(currentIdx));
                querys.add(this.rolePermissionsTable.execInsertQuery());
                rolePermissionId = Integer.toString(currentIdx);
                this.setRolePrincipalMapping(rolePermissionId, pc, p, querys);
                ++currentIdx;
            } else {
                while (roleIdResultSet.next()) {
                    rolePermissionId = roleIdResultSet.getString("rolepermissionid");
                    this.rolePermissionTable.setRolePermissionId(rolePermissionId);
                    querys.add(this.rolePermissionTable.execUpdateQuery());
                    this.setRolePrincipalMapping(rolePermissionId, pc, p, querys);
                }
            }
            roleIdResultSet.close();
        }
    }

    private void setRolePrincipalMapping(String rolePermissionId, PermissionMap pc, Permission p, Vector querys) {
        for (Principal prince : pc.getCheckedPermissionOwners(p)) {
            this.rolePrincipalTable.setDomain(this.domainName);
            this.rolePrincipalTable.setRolePermissionId(rolePermissionId);
            this.rolePrincipalTable.setUsername(prince.getName());
            querys.add(this.rolePrincipalTable.execInsertQuery());
        }
    }

    private void setResourceRoleMapping(String resourcePermissionId, PermissionMap pc, Permission p, Vector querys) throws SQLException {
        for (Role role : pc.getCheckedPermissionOwners(p)) {
            ResultSet roleIdResultSet = this.executeSelectQuery(this.rolePermissionTable.getSelectQuery(), new String[]{role.getName()});
            while (roleIdResultSet.next()) {
                this.resourceRoleTable.setDomain(this.domainName);
                this.resourceRoleTable.setResourcePermissionId(resourcePermissionId);
                this.resourceRoleTable.setRolePermissionId(roleIdResultSet.getString("rolepermissionid"));
                querys.add(this.resourceRoleTable.execInsertQuery());
            }
            roleIdResultSet.close();
        }
    }

    private void saveResourcePermission(int currentIdx, PermissionMap pc, String contextId, Vector querys) throws Exception {
        for (Permission p : pc.getAllPermissions()) {
            this.resourcePermissionTable.setResourcePermissionId(Integer.toString(currentIdx));
            this.resourcePermissionTable.setResource(p.getName());
            this.resourcePermissionTable.setClassname(p.getClass().getName());
            if (p.getActions() != null) {
                this.resourcePermissionTable.setActions(p.getActions());
            }
            if (pc.getExcludedPermissions().contains(p)) {
                this.resourcePermissionTable.setExcluded(true);
            }
            if (pc.getUncheckedPermissions().contains(p)) {
                this.resourcePermissionTable.setUnchecked(true);
            }
            ResultSet resourceIdResultSet = this.executeSelectQuery(this.resourcePermissionTable.getSelectQuery(), new String[]{p.getName()});
            querys.add(this.resourceRoleTable.getDeleteQuery());
            String resourcePermissionId = null;
            if (resourceIdResultSet.getRow() == 0) {
                querys.add(this.resourcePermissionTable.execInsertQuery());
                this.resourcePermissionsTable.setDomain(this.domainName);
                this.resourcePermissionsTable.setContextId(contextId);
                this.resourcePermissionsTable.setResourcePermissionId(Integer.toString(currentIdx));
                querys.add(this.resourcePermissionsTable.execInsertQuery());
                resourcePermissionId = Integer.toString(currentIdx);
                this.setResourceRoleMapping(resourcePermissionId, pc, p, querys);
                ++currentIdx;
            } else {
                while (resourceIdResultSet.next()) {
                    resourcePermissionId = resourceIdResultSet.getString("resourcepermissionid");
                    this.resourcePermissionTable.setResourcePermissionId(resourcePermissionId);
                    querys.add(this.resourcePermissionTable.execUpdateQuery());
                    this.setResourceRoleMapping(resourcePermissionId, pc, p, querys);
                }
            }
            resourceIdResultSet.close();
        }
    }

    public void create() throws Exception {
        this.rolePermissionsTable = new RolePermissionsTable(this.vendor, this.domainName);
        this.rolePermissionTable = new RolePermissionTable(this.vendor);
        this.rolePrincipalTable = new RolePrincipalTable(this.vendor, this.domainName);
        this.resourcePermissionsTable = new ResourcePermissionsTable(this.vendor, this.domainName);
        this.resourcePermissionTable = new ResourcePermissionTable(this.vendor);
        this.resourceRoleTable = new ResourceRoleTable(this.vendor, this.domainName);
        if (!super.checkExist(this.rolePermissionsTable.getCheckquery(), this.domainName)) {
            this.createSeqNoTable();
            ArrayList<String> createSqlList = new ArrayList<String>();
            createSqlList.add(this.rolePermissionsTable.getCreateQuery());
            createSqlList.add(this.rolePermissionTable.getCreateQuery());
            createSqlList.add(this.rolePrincipalTable.getCreateQuery());
            createSqlList.add(this.resourcePermissionsTable.getCreateQuery());
            createSqlList.add(this.resourcePermissionTable.getCreateQuery());
            createSqlList.add(this.resourceRoleTable.getCreateQuery());
            ArrayList initDataSqlList = new ArrayList();
            initDataSqlList.addAll(this.rolePermissionsTable.getInitQuery());
            initDataSqlList.addAll(this.rolePermissionTable.getInitQuery());
            initDataSqlList.addAll(this.rolePrincipalTable.getInitQuery());
            initDataSqlList.addAll(this.resourcePermissionsTable.getInitQuery());
            initDataSqlList.addAll(this.resourcePermissionTable.getInitQuery());
            initDataSqlList.addAll(this.resourceRoleTable.getInitQuery());
            ArrayList<String> dropSqlList = new ArrayList<String>();
            dropSqlList.add(this.rolePermissionsTable.getDropQuery());
            dropSqlList.add(this.rolePermissionTable.getDropQuery());
            dropSqlList.add(this.rolePrincipalTable.getDropQuery());
            dropSqlList.add(this.resourcePermissionsTable.getDropQuery());
            dropSqlList.add(this.resourcePermissionTable.getDropQuery());
            dropSqlList.add(this.resourceRoleTable.getDropQuery());
            String[] dropSqls = new String[dropSqlList.size()];
            dropSqlList.toArray(dropSqls);
            String[] createSqls = new String[createSqlList.size()];
            createSqlList.toArray(createSqls);
            String[] initDataSqls = new String[initDataSqlList.size()];
            initDataSqlList.toArray(initDataSqls);
            super.create(createSqls, initDataSqls);
        }
    }
}

