/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.installer;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.SecurityMo;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.impl.atn.ClientAuthenticationService;
import jeus.security.impl.atnrep.ClientAuthenticationRepositoryService;
import jeus.security.impl.azn.ClientAuthorizationService;
import jeus.security.impl.aznrep.ClientAuthorizationRepositoryService;
import jeus.security.impl.installer.CacheManagerService;
import jeus.security.impl.installer.XMLSecurityConverterFromSecurityManager;
import jeus.security.impl.login.ClientLoginService;
import jeus.security.impl.login.NoAuthClientLoginService;
import jeus.security.impl.network.ClientSocketNetworkService;
import jeus.security.impl.subfactory.PasswordSubjectFactoryService;
import jeus.security.impl.validation.ClientSubjectValidationService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NameAndPathUtil;

public class StandaloneJeusSecurityInstaller
extends SecurityInstaller {
    public SecurityMo securityMo = null;

    protected synchronized void doCreate() throws ServiceException, SecurityException {
    }

    public synchronized void doDestroy() {
    }

    protected void doInstallSecurity(Environment config) throws ServiceException, SecurityException {
        if (config.master) {
            this.installMasterSecurityServer(config);
        } else if (config.slave) {
            this.installSlaveSecurityServer(config);
        } else if (config.client) {
            this.installSecurityClient(config);
        } else {
            throw new ServiceException("Error installing security: none of master, slave or client was set to true in the passed in Environment");
        }
    }

    private void setupSharedDomain(Environment config) throws Exception {
        Domain d = this.makeSharedDomain("SHARED_DOMAIN", "");
        Iterator services = d.getServices().iterator();
        while (services.hasNext()) {
            Domain.SHARED_DOMAIN.addService((Service)services.next());
        }
    }

    private Domain makeSharedDomain(String domainName, String desc) throws Exception {
        Domain d = new Domain(domainName, desc);
        Environment sc = SecurityInstaller.getEnvironment();
        if (sc.master) {
            d.addService(this.getService("jeus.security.impl.network.StandaloneServerSocketNetworkService"));
        } else {
            d.addService(this.getService(Constants.DEFAULT_CLIENT_NETWORK_SERVICE_CLASSNAME));
        }
        return d;
    }

    private Service getService(String clazz) throws Exception {
        Service s = (Service)Class.forName(clazz).newInstance();
        return s;
    }

    protected void installMasterSecurityServer(Environment config) throws ServiceException {
        try {
            this.setupSharedDomain(config);
            this.makeCustomDomains(config);
            Domain.SHARED_DOMAIN.createAll();
        }
        catch (Exception e) {
            throw new ServiceException("Failed starting security service: unexpected exception occured", e);
        }
    }

    protected void installSlaveSecurityServer(Environment config) throws ServiceException {
        try {
            this.setupSharedDomain(config);
            this.makeCustomDomains(config);
            Domain.SHARED_DOMAIN.createAll();
        }
        catch (Exception e) {
            throw new ServiceException("Failed starting security service: unexpected exception occured", e);
        }
    }

    private void makeCustomDomains(Environment config) throws Exception {
        XMLSecurityConverterFromSecurityManager conv = new XMLSecurityConverterFromSecurityManager(config);
        File configFile = null;
        try {
            configFile = this.getConfigFile("security-manager.xml", NameAndPathUtil.getPathWithEndingSeparator(config.baseSecurityConfigurationDirectory));
        }
        catch (Exception e) {
            // empty catch block
        }
        Domain d = null;
        if (configFile.exists()) {
            Hashtable map = (Hashtable)conv.unmarshal(configFile);
            Enumeration keys = map.keys();
            while (keys.hasMoreElements()) {
                String domainName = (String)keys.nextElement();
                d = (Domain)map.get(domainName);
                Domain.addDomain(d);
            }
            for (int i = 0; i < config.domains.length; ++i) {
                Domain.getDomain(config.domains[i]).createAll();
            }
        } else {
            for (int i = 0; i < config.domains.length; ++i) {
                d = this.makeCustomDomain(config.domains[i], "");
                Domain.addDomain(d);
                Domain.getDomain(config.domains[i]).createAll();
            }
        }
    }

    private Domain makeCustomDomain(String domainName, String desc) throws Exception {
        Domain d = new Domain(domainName, desc);
        d.addService(this.getService(Constants.DEFAULT_USER_TO_CERT_MAPPING_SERVICE_CLASSNAME));
        d.addService(this.getService(Constants.DEFAULT_SERVER_LOGIN_SERVICE_CLASSNAME));
        d.addService(this.getService(Constants.DEFAULT_AUTHENTICATION_SERVICE_CLASSNAME));
        d.addService(this.getService(Constants.DEFAULT_PASSWORD_VERIFICATION_SERVICE_CLASSNAME));
        d.addService(this.getService(Constants.DEFAULT_AUTHORIZATION_SERVICE_CLASSNAME));
        d.addService(this.getService(Constants.DEFAULT_SYSTEM_AUTHENTICATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME));
        d.addService(this.getService(Constants.DEFAULT_SYSTEM_AUTHORIZATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME));
        return d;
    }

    private File getConfigFile(String filename, String baseDir) throws ServiceException {
        filename = filename == null ? baseDir + NameAndPathUtil.getPathWithEndingSeparator("security-manager.xml") : baseDir + NameAndPathUtil.getPathWithEndingSeparator(filename);
        return new File(filename);
    }

    protected void installSecurityClient(Environment config) throws ServiceException, SecurityException {
        int i;
        if (config.requiresSecurityManagement || config.requiresLocalAuthentication) {
            ClientSocketNetworkService csns = new ClientSocketNetworkService();
            Domain.SHARED_DOMAIN.addService(csns);
        }
        Domain.SHARED_DOMAIN.addService(new CacheManagerService());
        Domain.SHARED_DOMAIN.addService(new PasswordSubjectFactoryService());
        if (config.requiresLocalAuthentication) {
            Domain.SHARED_DOMAIN.addService(new ClientLoginService());
            Domain.SHARED_DOMAIN.addService(new ClientAuthenticationService());
            Domain.SHARED_DOMAIN.addService(new ClientSubjectValidationService());
        } else {
            Domain.SHARED_DOMAIN.addService(new NoAuthClientLoginService());
        }
        Domain.SHARED_DOMAIN.addService(new ClientAuthenticationRepositoryService());
        Domain.SHARED_DOMAIN.addService(new ClientAuthorizationService());
        Domain.SHARED_DOMAIN.addService(new ClientAuthorizationRepositoryService());
        for (i = 0; i < config.domains.length; ++i) {
            String csms;
            Domain d = new Domain(config.domains[i]);
            if (config.clientSubjectFactoryServiceClassnames != null && config.clientSubjectFactoryServiceClassnames.length > i && config.clientSubjectFactoryServiceClassnames[i] != null && (csms = config.clientSubjectFactoryServiceClassnames[i]) != null) {
                Service s;
                try {
                    s = (Service)Class.forName(csms).newInstance();
                }
                catch (Exception e) {
                    throw new ServiceException("Failed to install security system: error while loading a ClientSubjectMakerService", e);
                }
                d.addService(s);
            }
            Domain.addDomain(d);
        }
        Domain.SHARED_DOMAIN.createAll();
        for (i = 0; i < config.domains.length; ++i) {
            Domain.getDomain(config.domains[i]).createAll();
        }
    }

    public synchronized void doUninstallSecurity() {
        Environment config = SecurityInstaller.getEnvironment();
        if (config.master || config.slave) {
            this.uninstallSecurityServer(config);
        } else {
            this.uninstallSecurityClient();
        }
    }

    protected void uninstallSecurityServer(Environment config) {
        this.doUnregisterMBean();
        Domain.clearCurrentDomains();
        Vector<Domain> removed = new Vector<Domain>();
        Vector<Domain> ds = new Vector<Domain>();
        ds.addAll(Domain.getDomains());
        ds.add(Domain.SHARED_DOMAIN);
        Iterator domains = ds.iterator();
        while (domains.hasNext()) {
            try {
                Domain d = (Domain)domains.next();
                removed.add(d);
                d.destroyAll();
            }
            catch (Exception e) {}
        }
        Domain.clearDomains();
        for (Domain d : removed) {
            d.clearServices();
        }
    }

    protected void uninstallSecurityClient() {
        Domain.clearCurrentDomains();
        Iterator domains = Domain.getDomains().iterator();
        while (domains.hasNext()) {
            try {
                Domain d = (Domain)domains.next();
                d.destroyAll();
                d.clearServices();
            }
            catch (Exception exception) {}
        }
        Domain.clearDomains();
        Domain.SHARED_DOMAIN.destroyAll();
        Domain.SHARED_DOMAIN.clearServices();
    }

    public void doRegisterMBean(ObjectName parent) {
        block3: {
            try {
                this.securityMo = (SecurityMo)SecurityMo.createMBean("SecurityService", parent, this);
                for (Domain d : Domain.getDomains()) {
                    d.registerMBean(this.securityMo.getObjectName());
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block3;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    private void doUnregisterMBean() {
        block3: {
            try {
                if (this.securityMo != null) {
                    LoginService.loginCodeSubject();
                    this.securityMo.destroyMBean();
                    LoginService.logout();
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._8_LEVEL)) break block3;
                LoggerUtil.logger.log(JeusMessage_Security._8_LEVEL, JeusMessage_Security._8, (Throwable)e);
            }
        }
    }

    public String addDomain(String name) {
        try {
            Environment config = new Environment();
            XMLSecurityConverterFromSecurityManager conv = new XMLSecurityConverterFromSecurityManager(config);
            Domain d = (Domain)conv.unmarshal(this.getConfigFile("security-manager.xml", NameAndPathUtil.getPathWithEndingSeparator(config.baseSecurityConfigurationDirectory)));
            Domain.addDomain(d);
            Domain.getDomain(name).createAll();
            d.registerMBean(this.securityMo.getObjectName());
            return d.getObjectName();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._18_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._18_LEVEL, JeusMessage_Security._18, (Throwable)e);
            }
            return null;
        }
    }

    public void removeDomain(String name) {
        block2: {
            try {
                Domain d = Domain.getDomain(name);
                d.unregisterMBean();
                Domain.removeDomain(d);
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._19_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._19_LEVEL, JeusMessage_Security._19, (Throwable)e);
            }
        }
    }
}

