/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.impl.jacc.JACCDefaultPrincipalRoleMapper;
import jeus.security.impl.jacc.JACCPolicyConfigurationFactoryImpl;
import jeus.security.impl.jacc.JACCPolicyWrapper;
import jeus.security.resource.RoleImpl;

public class JACCPolicyConfigurationImpl
implements PolicyConfiguration {
    static final int OPEN_STATE = 0;
    static final int INSERVICE_STATE = 1;
    static final int DELETED_STATE = 2;
    private Policy policy;
    private String contextId;
    private int state;

    public JACCPolicyConfigurationImpl(String contextId) {
        this.contextId = contextId;
        this.policy = new Policy();
        this.setState(0);
    }

    void setState(int state) {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        this.state = state;
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        this.policy.getResourcePolicy(this.contextId, true).addPermission(permission, null, true, false);
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        Enumeration<Permission> perms = permissions.elements();
        while (perms.hasMoreElements()) {
            this.addToExcludedPolicy(perms.nextElement());
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        this.policy.getResourcePolicy(this.contextId, true).addPermission(permission, new Object[]{new RoleImpl(roleName)}, false, false);
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        Enumeration<Permission> perms = permissions.elements();
        while (perms.hasMoreElements()) {
            this.addToRole(roleName, perms.nextElement());
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        this.policy.getResourcePolicy(this.contextId, true).addPermission(permission, null, false, true);
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        Enumeration<Permission> perms = permissions.elements();
        while (perms.hasMoreElements()) {
            this.addToUncheckedPolicy(perms.nextElement());
        }
    }

    public void commit() throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 2) {
            throw new UnsupportedOperationException();
        }
        PermissionMap principalRoleMap = JACCDefaultPrincipalRoleMapper.getPrincipalRoleMapping(this.contextId);
        if (principalRoleMap != null) {
            this.policy.getRolePolicy().add(principalRoleMap);
        }
        try {
            JACCPolicyWrapper.theWrapper.policyContainer.addPolicy(this.policy);
        }
        catch (Exception e) {
            throw new PolicyContextException("Failed adding policy to JACC policy wrapper", (Throwable)e);
        }
        this.setState(1);
    }

    public void delete() throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        this.setState(2);
        JACCDefaultPrincipalRoleMapper.removePrincipalRoleMapping(this.contextId);
        JACCPolicyWrapper policy = this.getPolicy();
        if (policy != null) {
            try {
                policy.policyContainer.getPolicy(this.contextId).removeResourcePolicy(this.contextId);
            }
            catch (Exception e) {
                throw new PolicyContextException("Failed deleting policy from JACC policy wrapper", (Throwable)e);
            }
        }
        this.policy = new Policy();
    }

    private JACCPolicyWrapper getPolicy() throws PolicyContextException {
        JACCPolicyWrapper thePolicy = JACCPolicyWrapper.theWrapper;
        if (thePolicy != null && thePolicy instanceof JACCPolicyWrapper) {
            return thePolicy;
        }
        return null;
    }

    public String getContextID() throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        return this.contextId;
    }

    public boolean inService() throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        return this.state == 1;
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        try {
            JACCPolicyConfigurationImpl otherPC = (JACCPolicyConfigurationImpl)link;
            otherPC.policy.add(this.policy);
            this.policy = otherPC.policy;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        this.policy.getResourcePolicy(this.contextId).getExcludedPermissions().clear();
    }

    public void removeRole(String roleName) throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        this.policy.getResourcePolicy(this.contextId).getCheckedPermissions().remove(new RoleImpl(roleName));
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        JACCPolicyConfigurationFactoryImpl.checkSetPolicyPermission();
        if (this.state == 1 || this.state == 2) {
            throw new UnsupportedOperationException();
        }
        this.policy.getResourcePolicy(this.contextId).getUncheckedPermissions().clear();
    }
}

