/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.sql.DataSource;
import jeus.security.base.Domain;
import jeus.security.base.ServiceException;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RolePrincipalImpl;
import jeus.util.logging.JeusLogger;

public class DBRealmLoginModule
implements LoginModule {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security.login");
    protected String dsExportName;
    protected String principalsQuery = "select password from jeus_users where username=?";
    protected String rolesQuery = "select role from jeus_roles where username=?";
    private String username;
    private String password;
    private String domain;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    protected Map options;
    private Principal userPrincipal;
    private Password userCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        try {
            this.domain = Domain.getCurrentDomain().getName();
        }
        catch (ServiceException e) {
            this.domain = "SYSTEM_DOMAIN";
        }
        this.dsExportName = (String)options.get("exportName");
        if (this.dsExportName == null) {
            String msg = "LoginMoulde initialization failed. exportName option missing.";
            logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        Object tmp = options.get("principalsQuery");
        if (tmp != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        logger.debug("DBRealmLoginModule, export name : " + this.dsExportName);
        logger.debug("principalsQuery=" + this.principalsQuery);
        logger.debug("rolesQuery=" + this.rolesQuery);
        logger.debug("initialize successfully");
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = null;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        callbacks = new Callback[]{new NameCallback("user name: "), new PasswordCallback("password: ", false), new TextInputCallback("domain: ")};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.domain = ((TextInputCallback)callbacks[2]).getText();
            String expectedPassword = this.getUsersPassword();
            if (!this.validatePassword(this.password, expectedPassword)) {
                throw new LoginException("DBRealm authentication failed.");
            }
            this.succeeded = true;
        }
        catch (UnsupportedCallbackException uce) {
            uce.printStackTrace();
            LoginException le = new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
            le.initCause(uce);
            throw le;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            throw le;
        }
        return this.succeeded;
    }

    private String getUsersPassword() throws LoginException {
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsExportName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, this.username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("No matching username found");
            }
            password = rs.getString(1);
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            logger.debug("Query failed", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return password;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrivateCredentials().remove(this.userCredential);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        this.password = null;
        this.domain = null;
        this.userPrincipal = null;
        this.userCredential = null;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        ArrayList roles = this.getRoleSets();
        for (String roleName : roles) {
            logger.debug("Adding role to subject : username = " + this.username + ", roleName = " + roleName);
            this.subject.getPrincipals().add(new RolePrincipalImpl(roleName));
        }
        this.userCredential = new Password(this.password);
        this.subject.getPrivateCredentials().add(this.userCredential);
        this.username = null;
        this.password = null;
        this.domain = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.domain = null;
            this.userPrincipal = null;
            this.userCredential = null;
        } else {
            this.logout();
        }
        return true;
    }

    protected ArrayList getRoleSets() throws LoginException {
        Connection conn = null;
        HashMap setsMap = new HashMap();
        Statement ps = null;
        ResultSet rs = null;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsExportName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.rolesQuery);
            try {
                ps.setString(1, this.username);
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String rolename = rs.getString(1);
                roles.add(rolename);
            }
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            logger.debug("SQL failure", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        return roles;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        return inputPassword.equals(expectedPassword);
    }
}

