/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.io.IOException;
import java.security.Principal;
import java.security.SecurityPermission;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;

public class JAASUsernamePasswordLoginMoudle
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private String password;
    private boolean trusted;
    private String domain;
    private Principal userPrincipal;
    private Password userCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.trusted = false;
        this.domain = "SYSTEM_DOMAIN";
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    public boolean login() throws LoginException {
        Object sub = null;
        int selIndex = 0;
        Callback[] callbacks = null;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        callbacks = new Callback[]{new NameCallback("user name: "), new PasswordCallback("password: ", false), new ConfirmationCallback("trusted", 0, 0, 0), new TextInputCallback("domain: ")};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            selIndex = ((ConfirmationCallback)callbacks[2]).getSelectedIndex();
            this.trusted = selIndex == 0 || selIndex == 3;
            this.domain = ((TextInputCallback)callbacks[3]).getText();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        if (this.debug) {
            System.out.println("\t\t[ServerUsernamePasswordLoginMoudle] user entered user name: " + this.username);
            System.out.print("\t\t[ServerUsernamePasswordLoginMoudle] user entered password: ");
            System.out.println(this.password);
        }
        if (this.trusted && System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new SecurityPermission("runTrustedLogin"));
        }
        this.succeeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        this.userCredential = new Password(this.password);
        this.subject.getPrivateCredentials().add(this.userCredential);
        if (this.debug) {
            System.out.println("\t\t[ServerUsernamePasswordLoginMoudle] added Principal, Credential to Subject");
        }
        this.username = null;
        this.password = null;
        this.domain = null;
        this.trusted = false;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.domain = null;
            this.trusted = false;
            this.userPrincipal = null;
            this.userCredential = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrivateCredentials().remove(this.userCredential);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        this.password = null;
        this.domain = null;
        this.trusted = false;
        this.userPrincipal = null;
        this.userCredential = null;
        return true;
    }
}

