/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import jeus.security.impl.login.LoginModuleInfo;
import jeus.security.util.Constants;
import jeus.xml.binding.jeusDD.JaasLoginConfigType;
import jeus.xml.binding.jeusDD.LoginModuleType;
import jeus.xml.binding.jeusDD.OptionType;

public class JeusSecurityConfiguration
extends Configuration {
    private static Map appConfigs = Collections.synchronizedMap(new HashMap());

    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        LoginModuleInfo info = (LoginModuleInfo)appConfigs.get(name);
        return info.getAppConfigurationEntry();
    }

    public void refresh() {
        appConfigs.clear();
    }

    public void loadLoginConfig(String domainName, JaasLoginConfigType loginConfigType) {
        try {
            if (loginConfigType != null) {
                List list = loginConfigType.getLoginModule();
                ArrayList moduleList = new ArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    this.parseModule(list.get(i), moduleList);
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[moduleList.size()];
                moduleList.toArray(entries);
                LoginModuleInfo info = new LoginModuleInfo();
                info.setAppConfigurationEntry(entries);
                String callbackClassName = Constants.DEFAULT_CALLBACK_HANDLER_IMPL_CLASSNAME;
                if (loginConfigType.isSetCallbackHandlerClassname()) {
                    callbackClassName = loginConfigType.getCallbackHandlerClassname();
                }
                Class<?> clazz = Class.forName(callbackClassName);
                CallbackHandler handler = (CallbackHandler)clazz.newInstance();
                info.setAppCallbackHandler(handler);
                if (appConfigs.containsKey(domainName)) {
                    throw new KeyException("Config name: " + domainName + "already exists");
                }
                appConfigs.put(domainName, info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseModule(Object loginModule, ArrayList entries) throws Exception {
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        LoginModuleType moduleType = (LoginModuleType)loginModule;
        String className = moduleType.getLoginModuleClassname();
        if (moduleType.isSetControlFlag()) {
            String flag = moduleType.getControlFlag().value();
            flag = flag.toLowerCase();
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        List opts = moduleType.getOption();
        HashMap<String, String> options = new HashMap<String, String>();
        for (int n = 0; n < opts.size(); ++n) {
            OptionType optType = (OptionType)opts.get(n);
            options.put(optType.getName(), optType.getValue());
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(className, controlFlag, options);
        entries.add(entry);
    }

    public Map getAppConfigs() {
        return appConfigs;
    }

    public void setAppConfigs(Map appConfigs) {
        JeusSecurityConfiguration.appConfigs = appConfigs;
    }
}

