/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.SecurityPermission;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jeus.security.base.Domain;
import jeus.security.base.ServiceException;
import jeus.security.impl.atnrep.XMLAccountConverter;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.NameAndPathUtil;
import jeus.security.util.SubjectContainer;
import jeus.util.logging.JeusLogger;

public class JeusSystemLoginModule
implements LoginModule {
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private String password;
    private boolean trusted;
    private String domain;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Principal userPrincipal;
    private Password userCredential;
    private PrincipalImpl user;
    private boolean guestOnly;
    private XMLAccountConverter conv;
    private SubjectContainer subjectContainer;
    private String principalClassName = "jeus.security.resource.PrincipalImpl";
    protected Map sharedState;
    protected Map options;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security.impl.login");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        try {
            this.domain = Domain.getCurrentDomain().getName();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        logger.debug("initialize");
        this.principalClassName = (String)options.get("principalClass");
        try {
            File theFile;
            this.conv = new XMLAccountConverter(this.domain);
            this.subjectContainer = new SubjectContainer();
            String theFileName = (String)options.get("users.file");
            if (theFileName == null) {
                String baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                theFileName = baseDir + NameAndPathUtil.getPathWithEndingSeparator(this.domain) + "accounts.xml";
            }
            if ((theFile = new File(theFileName)) == null || !theFile.exists()) {
                return;
            }
            jeus.security.base.Subject[] subjects = (jeus.security.base.Subject[])this.conv.unmarshal(theFile);
            this.subjectContainer.clear();
            this.subjectContainer.addSubjectsFromArray(subjects);
            this.subjectContainer.setGroupTable(this.conv.getGroupsTable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        this.userCredential = new Password(this.password);
        this.subject.getPrivateCredentials().add(this.userCredential);
        if (this.debug) {
            System.out.println("\t\t[ServerUsernamePasswordLoginMoudle] added Principal, Credential to Subject");
        }
        this.username = null;
        this.password = null;
        this.domain = null;
        this.trusted = false;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.domain = null;
            this.trusted = false;
            this.userPrincipal = null;
            this.userCredential = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrivateCredentials().remove(this.userCredential);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        this.password = null;
        this.domain = null;
        this.trusted = false;
        this.userPrincipal = null;
        this.userCredential = null;
        return true;
    }

    public boolean login() throws LoginException {
        int selIndex = 0;
        Callback[] callbacks = null;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        callbacks = new Callback[]{new NameCallback("user name: "), new PasswordCallback("password: ", false), new ConfirmationCallback("trusted", 0, 0, 0), new TextInputCallback("domain: ")};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            selIndex = ((ConfirmationCallback)callbacks[2]).getSelectedIndex();
            this.trusted = selIndex == 0 || selIndex == 3;
            this.domain = ((TextInputCallback)callbacks[3]).getText();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        if (this.debug) {
            System.out.println("\t\t[ServerUsernamePasswordLoginMoudle] user entered user name: " + this.username);
            System.out.print("\t\t[ServerUsernamePasswordLoginMoudle] user entered password: ");
            System.out.println(this.password);
        }
        if (this.trusted && System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new SecurityPermission("runTrustedLogin"));
        }
        this.succeeded = true;
        return true;
    }

    protected Principal getIdentity() {
        Principal principal = this.user;
        if (principal == null) {
            principal = this.getIdentity();
        }
        return principal;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword == null) {
            this.guestOnly = true;
            isValid = true;
            this.user = new PrincipalImpl("guest");
        } else {
            isValid = inputPassword.equals(expectedPassword);
        }
        return isValid;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{new GroupPrincipalImpl("Roles")};
        if (!this.guestOnly) {
            roleSets[0].addMember((Principal)new PrincipalImpl("user"));
        }
        roleSets[0].addMember((Principal)new PrincipalImpl("guest"));
        return roleSets;
    }

    protected String getUsersPassword() throws LoginException {
        String username = this.getUsername();
        try {
            jeus.security.base.Subject subj = this.subjectContainer.getSubject(username);
            Set<Password> encodingPasswords = this.subject.getPrivateCredentials(Password.class);
            Object[] pwdobj = encodingPasswords.toArray();
            return ((Password)pwdobj[0]).getPassword();
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Principal createIdentity(String username) throws Exception {
        Principal p = null;
        if (this.principalClassName == null) {
            p = new PrincipalImpl(username);
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(this.principalClassName);
            Class[] ctorSig = new Class[]{String.class};
            Constructor<?> ctor = clazz.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{username};
            p = (Principal)ctor.newInstance(ctorArgs);
        }
        return p;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }
}

