/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jeus.security.impl.login.LdapAuthenticator;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RolePrincipalImpl;
import jeus.util.logging.JeusLogger;

public class LdapLoginModule
implements LoginModule {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security.loginmodule");
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private String password;
    private String domain;
    private Principal userPrincipal;
    private Password userCredential;
    private LdapAuthenticator authenticator;
    private static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    private static final String PROVIDER_URL = "providerURL";
    private static final String CONNECTION_USERNAME = "connectionUsername";
    private static final String CONNECTION_PASSWORD = "connectionPassword";
    private static final String USER_BASE = "userBase";
    private static final String USER_SEARCH_MAPPING = "userSearchMapping";
    private static final String USER_PASSWORD_ATTR = "userPasswordAttr";
    private static final String USER_ROLE_ATTR = "userRoleAttr";
    private static final String ROLE_BASE = "roleBase";
    private static final String ROLE_NAME_ATTR = "roleNameAttr";
    private static final String ROLE_SEARCH_MAPPING = "roleSearchMapping";
    private final String SUN_JDK_LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.domain = "SYSTEM_DOMAIN";
        this.authenticator = new LdapAuthenticator();
        this.initAuthenticator(this.authenticator, options);
    }

    private void initAuthenticator(LdapAuthenticator authenticator, Map options) {
        String value = (String)options.get(INITIAL_CONTEXT_FACTORY);
        if (value == null) {
            authenticator.setContextFactory("com.sun.jndi.ldap.LdapCtxFactory");
        } else {
            authenticator.setContextFactory(value);
        }
        authenticator.setProviderUrl((String)options.get(PROVIDER_URL));
        authenticator.setConnectionUsername((String)options.get(CONNECTION_USERNAME));
        authenticator.setConnectionPassword((String)options.get(CONNECTION_PASSWORD));
        value = (String)options.get(USER_BASE);
        if (value == null) {
            String msg = "LoginMoulde initialization failed. userBase option missing.";
            logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        authenticator.setUserBase(value);
        authenticator.setUserPasswordAttr((String)options.get(USER_PASSWORD_ATTR));
        value = (String)options.get(USER_SEARCH_MAPPING);
        if (value == null) {
            String msg = "LoginMoulde initialization failed. userSearchMapping option missing.";
            logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        authenticator.setUserSearchMapping(new MessageFormat(value));
        authenticator.setUserRoleAttr((String)options.get(USER_ROLE_ATTR));
        value = (String)options.get(ROLE_BASE);
        if (value == null) {
            String msg = "LoginMoulde initialization failed. roleBase option missing.";
            logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        authenticator.setRoleBase(value);
        value = (String)options.get(ROLE_NAME_ATTR);
        if (value == null) {
            String msg = "LoginMoulde initialization failed. roleNameAttr option missing.";
            logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        authenticator.setRoleNameAttr(value);
        value = (String)options.get(ROLE_SEARCH_MAPPING);
        if (value == null) {
            String msg = "LoginMoulde initialization failed. roleSearchMapping option missing.";
            logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        authenticator.setRoleSearchMapping(new MessageFormat(value));
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        ArrayList roles = this.authenticator.getRoles();
        for (String roleName : roles) {
            logger.fine("Adding role to subject : username = " + this.username + ", roleName = " + roleName);
            this.subject.getPrincipals().add(new RolePrincipalImpl(roleName));
        }
        this.userCredential = new Password(this.password);
        this.subject.getPrivateCredentials().add(this.userCredential);
        this.username = null;
        this.password = null;
        this.domain = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.domain = null;
            this.userPrincipal = null;
            this.userCredential = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrivateCredentials().remove(this.userCredential);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        this.password = null;
        this.domain = null;
        this.userPrincipal = null;
        this.userCredential = null;
        return true;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = null;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        callbacks = new Callback[]{new NameCallback("user name: "), new PasswordCallback("password: ", false), new TextInputCallback("domain: ")};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.domain = ((TextInputCallback)callbacks[2]).getText();
            if (!this.authenticator.authenticate(this.username, this.password)) {
                throw new LoginException("LDAP authentication failed.");
            }
            this.succeeded = true;
        }
        catch (UnsupportedCallbackException uce) {
            uce.printStackTrace();
            LoginException le = new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
            le.initCause(uce);
            throw le;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            throw le;
        }
        return this.succeeded;
    }
}

