/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.ClientService;
import jeus.security.base.CodeSubject;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.network.ClientSocketNetworkService;
import jeus.security.impl.network.SecurityConnectionListener;
import jeus.security.resource.Password;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.SystemPassword;
import jeus.security.spi.NetworkService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.NetworkUtil;
import jeus.util.EnvironmentCall;

public abstract class AbstractNetworkService
extends NetworkService {
    public static final int CONNECTION_MASTER = 0;
    public static final int CONNECTION_SLAVE = 1;
    public static final int CONNECTION_CLIENT = 2;
    private static ThreadLocal currentLink = new ThreadLocal();
    protected Endpoint endpoint;
    public static final String RETRY_ATTEMPTS_PROPERTY_KEY = "retries";
    protected static int retries = 5;
    protected static final Object[] connectPiggybackData = new Object[2];

    protected AbstractNetworkService() {
        retries = ((Environment)connectPiggybackData[1]).getRetries();
    }

    protected void doDestroy() {
        this.endpoint.unexport();
    }

    protected Environment[] doGetRemoteEnvironments() {
        SocketStream[] sockStreams = this.endpoint.getSocketStreams();
        Environment[] result = new Environment[sockStreams.length];
        for (int i = 0; i < sockStreams.length; ++i) {
            SocketStream sockStream = sockStreams[i];
            result[i] = ((SecurityConnectionListener)sockStream.getListener()).getRemoteEnvironment();
        }
        return result;
    }

    private SocketStream getExistingLink(Environment env) throws ConnectorException {
        if (env == null) {
            return null;
        }
        return this.endpoint.getSocketStream((SocketID)env.getNodeInfo(), retries, (Object)connectPiggybackData, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object handleMessage(NetworkMessage message, SocketStream source) {
        try {
            currentLink.set(source);
            Object object = this.processMessage(message);
            return object;
        }
        catch (Exception e) {
            Object object = this.processException(e);
            return object;
        }
        finally {
            currentLink.set(null);
        }
    }

    protected abstract Object processException(Exception var1);

    protected final Object doSendMessage(NetworkMessage message, boolean broadcast, Environment targetEnv) throws ServiceException, SecurityException {
        if (message == null) {
            throw new ServiceException("Error sending message over network: the message is null");
        }
        SocketStream[] streams = this.endpoint.getSocketStreams();
        if (streams.length == 0) {
            if (broadcast) {
                return null;
            }
            if (SecurityInstaller.getEnvironment().client) {
                this.connect();
                streams = this.endpoint.getSocketStreams();
                if (streams.length == 0) {
                    throw new ServiceException("Error sending message over network: no connections are established");
                }
            }
        }
        SocketStream sourceLink = (SocketStream)currentLink.get();
        try {
            if (targetEnv != null) {
                SocketStream target = this.getExistingLink(targetEnv);
                if (target == null) {
                    throw new ServiceException("Error sending message over network: the targeted link does not exist");
                }
                if (!target.isClosed()) {
                    return this.sendRequest(target, message, broadcast);
                }
            } else if (broadcast) {
                if (message.getBroadcastType() == 1) {
                    message.setBroadcastType(2);
                    this.endpoint.broadcast(0, sourceLink, (Object)AbstractNetworkService.convertToStream(message, true));
                }
                if (message.getBroadcastType() == 2) {
                    this.endpoint.broadcast(1, sourceLink, (Object)AbstractNetworkService.convertToStream(message, true));
                }
            } else {
                if (!(this instanceof ClientSocketNetworkService)) {
                    throw new ServiceException("Error sending message over network: the service is not allowed ServerSocketNetworkService");
                }
                if (!streams[0].isClosed()) {
                    return this.sendRequest(streams[0], message, false);
                }
            }
            return null;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (SecurityException sc) {
            throw sc;
        }
        catch (Exception e) {
            throw new ServiceException("Error sending message over network: unexpected exception occured", e);
        }
    }

    protected void connect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sendRequest(SocketStream target, NetworkMessage message, boolean async) throws Exception {
        Object result;
        SecurityConnectionListener listener;
        SecurityConnectionListener securityConnectionListener = listener = (SecurityConnectionListener)target.getListener();
        synchronized (securityConnectionListener) {
            if (!async) {
                listener.setWaitReply();
            }
            byte[] stream = AbstractNetworkService.convertToStream(message);
            target.write(stream);
            if (async) {
                return null;
            }
            result = listener.getReply();
        }
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        return result;
    }

    public static byte[] convertToStream(Object message) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        if (message instanceof NetworkMessage) {
            NetworkMessage networkmsg = (NetworkMessage)message;
            out.write(networkmsg.getOpcode());
            Subject subject = networkmsg.getSubject();
            if (subject == null) {
                out.writeByte(5);
            } else {
                String domain = subject.getDomainName();
                if (AnonymousSubject.isAnonymous(subject)) {
                    out.writeByte(1);
                    out.writeInt(domain.length());
                    out.writeBytes(domain);
                } else if (CodeSubject.isCode(subject)) {
                    out.writeByte(2);
                    out.writeInt(domain.length());
                    out.writeBytes(domain);
                } else if (subject.getPublicCredentials().isEmpty()) {
                    out.writeByte(3);
                    out.writeInt(domain.length());
                    out.writeBytes(domain);
                    String principal = subject.getPrincipal().getName();
                    Password passwordObj = subject.getPasswordObject();
                    String password = passwordObj.getPassword();
                    String algorithm = passwordObj.getAlgorithm();
                    out.writeInt(principal.length());
                    out.writeBytes(principal);
                    out.write(NetworkUtil.getAlgorithmType(algorithm));
                    out.writeInt(password.length());
                    out.writeBytes(password);
                    if (SystemPassword.getSystemPassword().equals(password)) {
                        out.writeBoolean(true);
                    } else {
                        out.writeBoolean(false);
                    }
                } else {
                    byte[] subjectSer;
                    block16: {
                        out.writeByte(4);
                        subjectSer = null;
                        try {
                            subjectSer = subject.serialize();
                        }
                        catch (Exception e) {
                            if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._24_LEVEL)) break block16;
                            LoggerUtil.logger.log(JeusMessage_Security._24_LEVEL, JeusMessage_Security._24, (Throwable)e);
                        }
                    }
                    if (subjectSer != null) {
                        out.writeInt(subjectSer.length);
                        out.write(subjectSer);
                    }
                }
            }
            out.writeBoolean(networkmsg.isBroadcasted());
            out.writeInt(networkmsg.getBroadcastType());
            out.writeObject(networkmsg.getArguments());
        } else if (message instanceof Exception) {
            out.write(-1);
            out.writeObject(message);
        }
        out.flush();
        return bout.toByteArray();
    }

    public static byte[] convertToStream(Object message, boolean broadcasted) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        if (message instanceof NetworkMessage) {
            NetworkMessage networkmsg = (NetworkMessage)message;
            networkmsg.setBroadcasted(broadcasted);
            out.write(networkmsg.getOpcode());
            Subject subject = networkmsg.getSubject();
            if (subject == null) {
                out.writeByte(5);
            } else {
                String domain = subject.getDomainName();
                if (AnonymousSubject.isAnonymous(subject)) {
                    out.writeByte(1);
                    out.writeInt(domain.length());
                    out.writeBytes(domain);
                } else if (CodeSubject.isCode(subject)) {
                    out.writeByte(2);
                    out.writeInt(domain.length());
                    out.writeBytes(domain);
                } else if (subject.getPublicCredentials().isEmpty()) {
                    out.writeByte(3);
                    out.writeInt(domain.length());
                    out.writeBytes(domain);
                    String principal = subject.getPrincipal().getName();
                    Password passwordObj = subject.getPasswordObject();
                    String password = passwordObj.getPassword();
                    String algorithm = passwordObj.getAlgorithm();
                    out.writeInt(principal.length());
                    out.writeBytes(principal);
                    out.write(NetworkUtil.getAlgorithmType(algorithm));
                    out.writeInt(password.length());
                    out.writeBytes(password);
                    if (SystemPassword.getSystemPassword().equals(password)) {
                        out.writeBoolean(true);
                    } else {
                        out.writeBoolean(false);
                    }
                } else {
                    byte[] subjectSer;
                    block16: {
                        out.writeByte(4);
                        subjectSer = null;
                        try {
                            subjectSer = subject.serialize();
                        }
                        catch (Exception e) {
                            if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._24_LEVEL)) break block16;
                            LoggerUtil.logger.log(JeusMessage_Security._24_LEVEL, JeusMessage_Security._24, (Throwable)e);
                        }
                    }
                    if (subjectSer != null) {
                        out.writeInt(subjectSer.length);
                        out.write(subjectSer);
                    }
                }
            }
            out.writeBoolean(networkmsg.isBroadcasted());
            out.writeInt(networkmsg.getBroadcastType());
            out.writeObject(networkmsg.getArguments());
        } else if (message instanceof Exception) {
            out.write(-1);
            out.writeObject(message);
        }
        out.flush();
        return bout.toByteArray();
    }

    public static Object convertFromStream(byte[] bytes) throws IOException, ClassNotFoundException, Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        byte opcode = in.readByte();
        if (opcode == -1) {
            return in.readObject();
        }
        byte subjectType = in.readByte();
        Subject subj = null;
        if (subjectType != 5) {
            byte[] domainName;
            if (subjectType == 1) {
                int size = in.readInt();
                domainName = new byte[size];
                in.readFully(domainName);
                subj = Domain.getAnonymousSubject(new String(domainName));
            } else if (subjectType == 2) {
                int size = in.readInt();
                domainName = new byte[size];
                in.readFully(domainName);
                subj = Domain.getCodeSubject(new String(domainName));
            } else if (subjectType == 3) {
                int size = in.readInt();
                domainName = new byte[size];
                in.readFully(domainName);
                size = in.readInt();
                byte[] username = new byte[size];
                in.readFully(username);
                byte algorithmType = in.readByte();
                size = in.readInt();
                byte[] password = new byte[size];
                in.readFully(password);
                boolean systemPasswordFlag = in.readBoolean();
                subj = new Subject(new String(domainName), new PrincipalImpl(new String(username)));
                if (systemPasswordFlag) {
                    SystemPassword.initialSystemPassword(subj);
                } else {
                    subj.getPrivateCredentials().add(new Password(NetworkUtil.getAlgorithmType(algorithmType), new String(password)));
                }
            } else if (subjectType == 4) {
                int size = in.readInt();
                byte[] subject = new byte[size];
                in.readFully(subject);
                subj = Subject.deserialize(subject);
            } else {
                throw new Exception("invalid subject type :" + Byte.toString(subjectType));
            }
        }
        boolean broadcasted = in.readBoolean();
        int broadcastType = in.readInt();
        Serializable[] sers = (Serializable[])in.readObject();
        return new NetworkMessage(opcode, subj, broadcasted, broadcastType, sers);
    }

    protected final Object doSendMessage(NetworkMessage message, String targetNode) throws ServiceException, SecurityException {
        int port;
        String node;
        int idx;
        Environment targetEnv = null;
        String realnode = targetNode;
        if (realnode.indexOf(":") < 0) {
            realnode = EnvironmentCall.getRealNodeName((String)targetNode);
        }
        if ((idx = realnode.indexOf(":")) == -1) {
            node = realnode;
            port = EnvironmentCall.getJeusBasePort();
        } else {
            node = realnode.substring(0, idx);
            port = Integer.parseInt(realnode.substring(idx + 1));
        }
        SocketStream[] streams = this.endpoint.getSocketStreams();
        for (int i = 0; i < streams.length; ++i) {
            SocketStream stream = streams[i];
            Environment remoteEnv = ((SecurityConnectionListener)stream.getListener()).getRemoteEnvironment();
            if (!remoteEnv.hostNames[0].equals(node) || remoteEnv.remoteBaseSecurityPorts[0] != port) continue;
            targetEnv = remoteEnv;
            break;
        }
        if (targetEnv == null) {
            throw new ServiceException("Error sending message over network: the targeted link(" + targetNode + "[" + node + ":" + port + "]) does not exist");
        }
        return this.doSendMessage(message, false, targetEnv);
    }

    public void cleanup(Environment remoteEnv) {
        if (remoteEnv != null) {
            String node = remoteEnv.localHostName + ":" + remoteEnv.baseSecurityPort;
            Vector<Domain> ds = new Vector<Domain>();
            ds.add(Domain.SHARED_DOMAIN);
            ds.addAll(Domain.getDomains());
            Iterator domains = ds.iterator();
            while (domains.hasNext()) {
                try {
                    Domain d = (Domain)domains.next();
                    Collection c = d.getServices();
                    for (Service s : c) {
                        if (!(s instanceof ClientService)) continue;
                        ClientService cs = (ClientService)((Object)s);
                        cs.removeCache(node);
                    }
                }
                catch (Exception e) {
                }
            }
        }
    }

    static {
        Environment localEnv = SecurityInstaller.getEnvironment();
        if (localEnv == null) {
            throw new RuntimeException("No Environment set - security is not installed");
        }
        AbstractNetworkService.connectPiggybackData[0] = SecurityInstaller.getGlobalPassword();
        AbstractNetworkService.connectPiggybackData[1] = localEnv;
    }
}

